% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{auto_distance_cpp}
\alias{auto_distance_cpp}
\title{(C++) Sum Distances Between Consecutive Samples in a Time Series}
\usage{
auto_distance_cpp(x, distance = "euclidean")
}
\arguments{
\item{x}{(required, numeric matrix) univariate or multivariate time series.}

\item{distance}{(optional, character string) distance name from the "names"
column of the dataset \code{distances} (see \code{distances$name}). Default: "euclidean"}
}
\value{
numeric
}
\description{
Computes the cumulative sum of distances between consecutive
samples in a univariate or multivariate time series.
NA values should be removed before using this function.
}
\examples{
#simulate a time series
x <- zoo_simulate()

#compute auto distance
auto_distance_cpp(
  x = x,
  distance = "euclidean"
  )
}
\seealso{
Other Rcpp_auto_sum: 
\code{\link{auto_sum_cpp}()},
\code{\link{auto_sum_full_cpp}()},
\code{\link{auto_sum_path_cpp}()},
\code{\link{subset_matrix_by_rows_cpp}()}
}
\concept{Rcpp_auto_sum}
