% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_vector_to_matrix.R
\name{zoo_vector_to_matrix}
\alias{zoo_vector_to_matrix}
\title{Coerce Coredata of Univariate Zoo Time Series to Matrix}
\usage{
zoo_vector_to_matrix(x = NULL, name = NULL)
}
\arguments{
\item{x}{(required, zoo object) zoo time series. Default: NULL}

\item{name}{(required, character string) name of the matrix column. Default: NULL}
}
\value{
zoo time series
}
\description{
Transforms vector coredata of univariate zoo time series to class matrix. If the input zoo time series has the attribute "name", the output inherits the value of such attribute.

Multivariate zoo objects are returned without changes.
}
\examples{
#create zoo object from vector
x <- zoo::zoo(
  x = runif(100)
)

#coredata is not a matrix
is.matrix(zoo::coredata(x))

#convert to matrix
y <- zoo_vector_to_matrix(
  x = x
)

#coredata is now a matrix
is.matrix(zoo::coredata(y))
}
\seealso{
Other zoo_functions: 
\code{\link{zoo_aggregate}()},
\code{\link{zoo_name_clean}()},
\code{\link{zoo_name_get}()},
\code{\link{zoo_name_set}()},
\code{\link{zoo_permute}()},
\code{\link{zoo_plot}()},
\code{\link{zoo_resample}()},
\code{\link{zoo_smooth_exponential}()},
\code{\link{zoo_smooth_window}()},
\code{\link{zoo_time}()},
\code{\link{zoo_to_tsl}()}
}
\concept{zoo_functions}
