% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querycount.R
\name{QueryCountWorker}
\alias{QueryCountWorker}
\title{R6 worker object for use as a worker with master objects generated by \code{\link[=QueryCountMaster]{QueryCountMaster()}}}
\description{
\code{QueryCountWorker} objects are worker objects at each site of
a distributed QueryCount model computation
}
\seealso{
\code{\link[=QueryCountMaster]{QueryCountMaster()}} which goes hand-in-hand with this object
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-QueryCountWorker-new}{\code{QueryCountWorker$new()}}
\item \href{#method-QueryCountWorker-getStateful}{\code{QueryCountWorker$getStateful()}}
\item \href{#method-QueryCountWorker-kosher}{\code{QueryCountWorker$kosher()}}
\item \href{#method-QueryCountWorker-queryCount}{\code{QueryCountWorker$queryCount()}}
\item \href{#method-QueryCountWorker-clone}{\code{QueryCountWorker$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryCountWorker-new"></a>}}
\if{latex}{\out{\hypertarget{method-QueryCountWorker-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{QueryCountWorker} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryCountWorker$new(defn, data, stateful = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{defn}}{the computation definition}

\item{\code{data}}{the local data}

\item{\code{stateful}}{the statefulness flag, default \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{QueryCountWorker} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryCountWorker-getStateful"></a>}}
\if{latex}{\out{\hypertarget{method-QueryCountWorker-getStateful}{}}}
\subsection{Method \code{getStateful()}}{
Retrieve the value of the \code{stateful} field
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryCountWorker$getStateful()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryCountWorker-kosher"></a>}}
\if{latex}{\out{\hypertarget{method-QueryCountWorker-kosher}{}}}
\subsection{Method \code{kosher()}}{
Check if inputs and state of object are sane. For future use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryCountWorker$kosher()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} or \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryCountWorker-queryCount"></a>}}
\if{latex}{\out{\hypertarget{method-QueryCountWorker-queryCount}{}}}
\subsection{Method \code{queryCount()}}{
Return the query count on the local data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryCountWorker$queryCount()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryCountWorker-clone"></a>}}
\if{latex}{\out{\hypertarget{method-QueryCountWorker-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryCountWorker$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
