% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wrapper_VectorDistribution.R
\name{VectorDistribution}
\alias{VectorDistribution}
\title{Vectorise Distributions}
\description{
A wrapper for creating a vector of distributions.
}
\details{
A vector distribution is intented to vectorize distributions more efficiently than
storing a list of distributions. To improve speed and reduce memory usage, distributions are
only constructed when methods (e.g. d/p/q/r) are called.
}
\examples{

## ------------------------------------------------
## Method `VectorDistribution$new`
## ------------------------------------------------

\dontrun{
VectorDistribution$new(
  distribution = "Binomial",
  params = list(
    list(prob = 0.1, size = 2),
    list(prob = 0.6, size = 4),
    list(prob = 0.2, size = 6)
  )
)

VectorDistribution$new(
  distribution = "Binomial",
  params = data.table::data.table(prob = c(0.1, 0.6, 0.2), size = c(2, 4, 6))
)

# Alternatively
VectorDistribution$new(
  list(
  Binomial$new(prob = 0.1, size = 2),
  Binomial$new(prob = 0.6, size = 4),
  Binomial$new(prob = 0.2, size = 6)
  )
)
}

## ------------------------------------------------
## Method `VectorDistribution$pdf`
## ------------------------------------------------

vd <- VectorDistribution$new(
 distribution = "Binomial",
 params = data.frame(size = 9:10, prob = c(0.5,0.6)))

vd$pdf(2)
# Equivalently
vd$pdf(2, 2)

vd$pdf(1:2, 3:4)
# or as a matrix
vd$pdf(data = matrix(1:4, nrow = 2))

# when wrapping multivariate distributions, arrays are required
vd <- VectorDistribution$new(
 distribution = "Multinomial",
 params = list(
 list(size = 5, probs = c(0.1, 0.9)),
 list(size = 8, probs = c(0.3, 0.7))
 )
 )

# evaluates Multinom1 and Multinom2 at (1, 4)
vd$pdf(1, 4)

# evaluates Multinom1 at (1, 4) and Multinom2 at (5, 3)
vd$pdf(data = array(c(1,4,5,3), dim = c(1,2,2)))

# and the same across many samples
vd$pdf(data = array(c(1,2,4,3,5,1,3,7), dim = c(2,2,2)))
}
\seealso{
Other wrappers: 
\code{\link{Convolution}},
\code{\link{DistributionWrapper}},
\code{\link{HuberizedDistribution}},
\code{\link{MixtureDistribution}},
\code{\link{ProductDistribution}},
\code{\link{TruncatedDistribution}}
}
\concept{wrappers}
\section{Super classes}{
\code{\link[distr6:Distribution]{distr6::Distribution}} -> \code{\link[distr6:DistributionWrapper]{distr6::DistributionWrapper}} -> \code{VectorDistribution}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{modelTable}}{Returns reference table of wrapped \link{Distribution}s.}

\item{\code{distlist}}{Returns list of constructed wrapped \link{Distribution}s.}

\item{\code{ids}}{Returns ids of constructed wrapped \link{Distribution}s.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{VectorDistribution$new()}}
\item \href{#method-getParameterValue}{\code{VectorDistribution$getParameterValue()}}
\item \href{#method-wrappedModels}{\code{VectorDistribution$wrappedModels()}}
\item \href{#method-strprint}{\code{VectorDistribution$strprint()}}
\item \href{#method-mean}{\code{VectorDistribution$mean()}}
\item \href{#method-mode}{\code{VectorDistribution$mode()}}
\item \href{#method-median}{\code{VectorDistribution$median()}}
\item \href{#method-variance}{\code{VectorDistribution$variance()}}
\item \href{#method-skewness}{\code{VectorDistribution$skewness()}}
\item \href{#method-kurtosis}{\code{VectorDistribution$kurtosis()}}
\item \href{#method-entropy}{\code{VectorDistribution$entropy()}}
\item \href{#method-mgf}{\code{VectorDistribution$mgf()}}
\item \href{#method-cf}{\code{VectorDistribution$cf()}}
\item \href{#method-pgf}{\code{VectorDistribution$pgf()}}
\item \href{#method-pdf}{\code{VectorDistribution$pdf()}}
\item \href{#method-cdf}{\code{VectorDistribution$cdf()}}
\item \href{#method-quantile}{\code{VectorDistribution$quantile()}}
\item \href{#method-rand}{\code{VectorDistribution$rand()}}
\item \href{#method-clone}{\code{VectorDistribution$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="correlation">}\href{../../distr6/html/Distribution.html#method-correlation}{\code{distr6::Distribution$correlation()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="iqr">}\href{../../distr6/html/Distribution.html#method-iqr}{\code{distr6::Distribution$iqr()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="liesInSupport">}\href{../../distr6/html/Distribution.html#method-liesInSupport}{\code{distr6::Distribution$liesInSupport()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="liesInType">}\href{../../distr6/html/Distribution.html#method-liesInType}{\code{distr6::Distribution$liesInType()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="parameters">}\href{../../distr6/html/Distribution.html#method-parameters}{\code{distr6::Distribution$parameters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="prec">}\href{../../distr6/html/Distribution.html#method-prec}{\code{distr6::Distribution$prec()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="print">}\href{../../distr6/html/Distribution.html#method-print}{\code{distr6::Distribution$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="setParameterValue">}\href{../../distr6/html/Distribution.html#method-setParameterValue}{\code{distr6::Distribution$setParameterValue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="stdev">}\href{../../distr6/html/Distribution.html#method-stdev}{\code{distr6::Distribution$stdev()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="summary">}\href{../../distr6/html/Distribution.html#method-summary}{\code{distr6::Distribution$summary()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="workingSupport">}\href{../../distr6/html/Distribution.html#method-workingSupport}{\code{distr6::Distribution$workingSupport()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$new(
  distlist = NULL,
  distribution = NULL,
  params = NULL,
  shared_params = NULL,
  name = NULL,
  short_name = NULL,
  decorators = NULL,
  vecdist = NULL,
  ids = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distlist}}{\code{(list())}\cr
List of \link{Distribution}s.}

\item{\code{distribution}}{\code{(character(1))} \cr
Should be supplied with \code{params} and optionally \code{shared_params} as an alternative to \code{distlist}.
Much faster implementation when only one class of distribution is being wrapped. \code{distribution}
is the full name of one of the distributions in \code{\link[=listDistributions]{listDistributions()}}, or \code{"Distribution"} if
constructing custom distributions. See examples in \link{VectorDistribution}.}

\item{\code{params}}{\code{(list()|data.frame())} \cr
Parameters in the individual distributions for use with \code{distribution}. Can be supplied as a list,
where each element is the list of parameters to set in the distribution, or as an object
coercable to \code{data.frame}, where each column is a parameter and each row is a distribution.
See examples in \link{VectorDistribution}.}

\item{\code{shared_params}}{\code{(list())}\cr
If any parameters are shared when using the \code{distribution} constructor, this provides a much faster
implementation to list and query them together. See examples in \link{VectorDistribution}.}

\item{\code{name}}{\code{(character(1))}\cr
Optional name of wrapped distribution.}

\item{\code{short_name}}{\code{(character(1))}\cr
Optional short name/ID of wrapped distribution.}

\item{\code{decorators}}{\code{(character())} \cr
Decorators to add to the distribution during construction.}

\item{\code{vecdist}}{\link{VectorDistribution} \cr
Alternative constructor to directly create this object from an object inheriting from
\link{VectorDistribution}.}

\item{\code{ids}}{\code{(character())} \cr
Optional ids for wrapped distributions in vector, should be unique and of same length as
the number of distributions.}

\item{\code{...}}{Unused}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
VectorDistribution$new(
  distribution = "Binomial",
  params = list(
    list(prob = 0.1, size = 2),
    list(prob = 0.6, size = 4),
    list(prob = 0.2, size = 6)
  )
)

VectorDistribution$new(
  distribution = "Binomial",
  params = data.table::data.table(prob = c(0.1, 0.6, 0.2), size = c(2, 4, 6))
)

# Alternatively
VectorDistribution$new(
  list(
  Binomial$new(prob = 0.1, size = 2),
  Binomial$new(prob = 0.6, size = 4),
  Binomial$new(prob = 0.2, size = 6)
  )
)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getParameterValue"></a>}}
\if{latex}{\out{\hypertarget{method-getParameterValue}{}}}
\subsection{Method \code{getParameterValue()}}{
Returns the value of the supplied parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$getParameterValue(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character()} \cr
id of parameter value to return.}

\item{\code{...}}{Unused}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wrappedModels"></a>}}
\if{latex}{\out{\hypertarget{method-wrappedModels}{}}}
\subsection{Method \code{wrappedModels()}}{
Returns model(s) wrapped by this wrapper.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$wrappedModels(model = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{\code{(character(1))} \cr
id of wrapped \link{Distribution}s to return. If \code{NULL} (default), a list of all wrapped
\link{Distribution}s is returned; if only one \link{Distribution} is matched then this is returned,
otherwise a list of \link{Distribution}s.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-strprint"></a>}}
\if{latex}{\out{\hypertarget{method-strprint}{}}}
\subsection{Method \code{strprint()}}{
Printable string representation of the \code{VectorDistribution}. Primarily used internally.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$strprint(n = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{\code{(integer(1))}\cr
Number of distributions to include when printing.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mean"></a>}}
\if{latex}{\out{\hypertarget{method-mean}{}}}
\subsection{Method \code{mean()}}{
Returns named vector of means from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$mean(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Passed to \link{CoreStatistics}\verb{$genExp} if numeric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mode"></a>}}
\if{latex}{\out{\hypertarget{method-mode}{}}}
\subsection{Method \code{mode()}}{
Returns named vector of modes from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$mode(which = "all")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{which}}{\verb{(character(1) | numeric(1)}\cr
Ignored if distribution is unimodal. Otherwise \code{"all"} returns all modes, otherwise specifies
which mode to return.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-median"></a>}}
\if{latex}{\out{\hypertarget{method-median}{}}}
\subsection{Method \code{median()}}{
Returns named vector of medians from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$median()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-variance"></a>}}
\if{latex}{\out{\hypertarget{method-variance}{}}}
\subsection{Method \code{variance()}}{
Returns named vector of variances from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$variance(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Passed to \link{CoreStatistics}\verb{$genExp} if numeric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-skewness"></a>}}
\if{latex}{\out{\hypertarget{method-skewness}{}}}
\subsection{Method \code{skewness()}}{
Returns named vector of skewness from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$skewness(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Passed to \link{CoreStatistics}\verb{$genExp} if numeric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-kurtosis"></a>}}
\if{latex}{\out{\hypertarget{method-kurtosis}{}}}
\subsection{Method \code{kurtosis()}}{
Returns named vector of kurtosis from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$kurtosis(excess = TRUE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{excess}}{\code{(logical(1))} \cr
If \code{TRUE} (default) excess kurtosis returned.}

\item{\code{...}}{Passed to \link{CoreStatistics}\verb{$genExp} if numeric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-entropy"></a>}}
\if{latex}{\out{\hypertarget{method-entropy}{}}}
\subsection{Method \code{entropy()}}{
Returns named vector of entropy from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$entropy(base = 2, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base}}{\code{(integer(1))} \cr
Base of the entropy logarithm, default = 2 (Shannon entropy)}

\item{\code{...}}{Passed to \link{CoreStatistics}\verb{$genExp} if numeric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mgf"></a>}}
\if{latex}{\out{\hypertarget{method-mgf}{}}}
\subsection{Method \code{mgf()}}{
Returns named vector of mgf from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$mgf(t, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{\code{(integer(1))} \cr
t integer to evaluate function at.}

\item{\code{...}}{Passed to \link{CoreStatistics}\verb{$genExp} if numeric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cf"></a>}}
\if{latex}{\out{\hypertarget{method-cf}{}}}
\subsection{Method \code{cf()}}{
Returns named vector of cf from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$cf(t, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{\code{(integer(1))} \cr
t integer to evaluate function at.}

\item{\code{...}}{Passed to \link{CoreStatistics}\verb{$genExp} if numeric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgf"></a>}}
\if{latex}{\out{\hypertarget{method-pgf}{}}}
\subsection{Method \code{pgf()}}{
Returns named vector of pgf from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$pgf(z, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{z}}{\code{(integer(1))} \cr
z integer to evaluate probability generating function at.}

\item{\code{...}}{Passed to \link{CoreStatistics}\verb{$genExp} if numeric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pdf"></a>}}
\if{latex}{\out{\hypertarget{method-pdf}{}}}
\subsection{Method \code{pdf()}}{
Returns named vector of pdfs from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$pdf(..., log = FALSE, simplify = TRUE, data = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{(numeric())} \cr
Points to evaluate the function at Arguments do not need
to be named. The length of each argument corresponds to the number of points to evaluate,
the number of arguments corresponds to the number of variables in the distribution.
See examples.}

\item{\code{log}}{\code{(logical(1))} \cr
If \code{TRUE} returns the logarithm of the probabilities. Default is \code{FALSE}.}

\item{\code{simplify}}{\code{logical(1)} \cr
If \code{TRUE} (default) simplifies the return if possible to a \code{numeric}, otherwise returns a
\link[=data.table]{data.table::data.table}.}

\item{\code{data}}{\link{array} \cr
Alternative method to specify points to evaluate. If univariate then rows correspond with number
of points to evaluate and columns correspond with number of variables to evaluate. In the special
case of \link{VectorDistribution}s of multivariate distributions, then the third dimension corresponds
to the distribution in the vector to evaluate.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{vd <- VectorDistribution$new(
 distribution = "Binomial",
 params = data.frame(size = 9:10, prob = c(0.5,0.6)))

vd$pdf(2)
# Equivalently
vd$pdf(2, 2)

vd$pdf(1:2, 3:4)
# or as a matrix
vd$pdf(data = matrix(1:4, nrow = 2))

# when wrapping multivariate distributions, arrays are required
vd <- VectorDistribution$new(
 distribution = "Multinomial",
 params = list(
 list(size = 5, probs = c(0.1, 0.9)),
 list(size = 8, probs = c(0.3, 0.7))
 )
 )

# evaluates Multinom1 and Multinom2 at (1, 4)
vd$pdf(1, 4)

# evaluates Multinom1 at (1, 4) and Multinom2 at (5, 3)
vd$pdf(data = array(c(1,4,5,3), dim = c(1,2,2)))

# and the same across many samples
vd$pdf(data = array(c(1,2,4,3,5,1,3,7), dim = c(2,2,2)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cdf"></a>}}
\if{latex}{\out{\hypertarget{method-cdf}{}}}
\subsection{Method \code{cdf()}}{
Returns named vector of cdfs from each wrapped \link{Distribution}.
Same usage as \verb{$pdf.}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$cdf(
  ...,
  lower.tail = TRUE,
  log.p = FALSE,
  simplify = TRUE,
  data = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{(numeric())} \cr
Points to evaluate the function at Arguments do not need
to be named. The length of each argument corresponds to the number of points to evaluate,
the number of arguments corresponds to the number of variables in the distribution.
See examples.}

\item{\code{lower.tail}}{\code{(logical(1))} \cr
If \code{TRUE} (default), probabilities are \code{X <= x}, otherwise, \code{P(X > x)}.}

\item{\code{log.p}}{\code{(logical(1))} \cr
If \code{TRUE} returns the logarithm of the probabilities. Default is \code{FALSE}.}

\item{\code{simplify}}{\code{logical(1)} \cr
If \code{TRUE} (default) simplifies the return if possible to a \code{numeric}, otherwise returns a
\link[=data.table]{data.table::data.table}.}

\item{\code{data}}{\link{array} \cr
Alternative method to specify points to evaluate. If univariate then rows correspond with number
of points to evaluate and columns correspond with number of variables to evaluate. In the special
case of \link{VectorDistribution}s of multivariate distributions, then the third dimension corresponds
to the distribution in the vector to evaluate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-quantile}{}}}
\subsection{Method \code{quantile()}}{
Returns named vector of quantiles from each wrapped \link{Distribution}.
Same usage as \verb{$cdf.}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$quantile(
  ...,
  lower.tail = TRUE,
  log.p = FALSE,
  simplify = TRUE,
  data = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{(numeric())} \cr
Points to evaluate the function at Arguments do not need
to be named. The length of each argument corresponds to the number of points to evaluate,
the number of arguments corresponds to the number of variables in the distribution.
See examples.}

\item{\code{lower.tail}}{\code{(logical(1))} \cr
If \code{TRUE} (default), probabilities are \code{X <= x}, otherwise, \code{P(X > x)}.}

\item{\code{log.p}}{\code{(logical(1))} \cr
If \code{TRUE} returns the logarithm of the probabilities. Default is \code{FALSE}.}

\item{\code{simplify}}{\code{logical(1)} \cr
If \code{TRUE} (default) simplifies the return if possible to a \code{numeric}, otherwise returns a
\link[=data.table]{data.table::data.table}.}

\item{\code{data}}{\link{array} \cr
Alternative method to specify points to evaluate. If univariate then rows correspond with number
of points to evaluate and columns correspond with number of variables to evaluate. In the special
case of \link{VectorDistribution}s of multivariate distributions, then the third dimension corresponds
to the distribution in the vector to evaluate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rand"></a>}}
\if{latex}{\out{\hypertarget{method-rand}{}}}
\subsection{Method \code{rand()}}{
Returns \link[data.table:data.table]{data.table::data.table} of draws from each wrapped \link{Distribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$rand(n, simplify = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{\code{(numeric(1))} \cr
Number of points to simulate from the distribution. If length greater than \eqn{1}, then
\code{n <- length(n)},}

\item{\code{simplify}}{\code{logical(1)} \cr
If \code{TRUE} (default) simplifies the return if possible to a \code{numeric}, otherwise returns a
\link[=data.table]{data.table::data.table}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorDistribution$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
