% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateEmpiricalDistribution.R
\name{simulateEmpiricalDistribution}
\alias{simulateEmpiricalDistribution}
\title{Sample Empirical Distribution Without Replacement}
\usage{
simulateEmpiricalDistribution(EmpiricalDist, n, seed = NULL)
}
\arguments{
\item{EmpiricalDist}{Empirical Distribution}

\item{n}{Number of samples to generate. See Details.}

\item{seed}{Numeric passed to \code{set.seed}. See Details.}
}
\value{
A vector of length \code{n} with elements drawn without replacement from the given
Empirical distribution.
}
\description{
Function to sample \link{Empirical} Distributions without replacement, as
opposed to the \code{rand} method which samples with replacement.
}
\details{
This function can only be used to sample from the \code{Empirical} distribution without
replacement, and will return an error for other distributions.

The \code{seed} param ensures that the same samples can be reproduced and is more convenient than
using the \code{\link[=set.seed]{set.seed()}} function each time before use. If \code{set.seed} is \code{NULL} then the
seed is left unchanged (NULL is not passed to the \code{set.seed} function).

If \code{n} is of length greater than one, then \code{n} is taken to be the length of \code{n}.
If \code{n} is greater than the number of observations in the Empirical distribution, then
\code{n} is taken to be the number of observations in the distribution.
}
