% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FisherF.R
\name{FisherF}
\alias{FisherF}
\title{Create an F distribution}
\usage{
FisherF(df1, df2, lambda = 0)
}
\arguments{
\item{df1}{Numerator degrees of freedom. Can be any positive number.}

\item{df2}{Denominator degrees of freedom. Can be any positive number.}

\item{lambda}{Non-centrality parameter. Can be any positive number.
Defaults to \code{0}.}
}
\value{
A \code{FisherF} object.
}
\description{
Create an F distribution
}
\examples{

set.seed(27)

X <- FisherF(5, 10, 0.2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
\seealso{
Other continuous distributions: \code{\link{Beta}},
  \code{\link{Cauchy}}, \code{\link{ChiSquare}},
  \code{\link{Exponential}}, \code{\link{Gamma}},
  \code{\link{LogNormal}}, \code{\link{Logistic}},
  \code{\link{Normal}}, \code{\link{StudentsT}},
  \code{\link{Tukey}}, \code{\link{Uniform}},
  \code{\link{Weibull}}
}
\concept{continuous distributions}
