% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{random.Beta}
\alias{random.Beta}
\title{Draw a random sample from a Beta distribution}
\usage{
\method{random}{Beta}(x, n = 1L, ...)
}
\arguments{
\item{x}{A \code{Beta} object created by a call to \code{\link[=Beta]{Beta()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A numeric vector containing values in \verb{[0, 1]} of length \code{n}.
}
\description{
Draw a random sample from a Beta distribution
}
\examples{

set.seed(27)

X <- Beta(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

mean(X)
variance(X)
skewness(X)
kurtosis(X)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
