% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltab.R
\name{modeltab}
\alias{modeltab}
\title{Origination/extinction response table for statistical modelling.}
\usage{
modeltab(x, tax, bin, taxvars = NULL, rt = FALSE, singletons = FALSE)
}
\arguments{
\item{x}{\code{(data.frame)} Fossil occurrence table.}

\item{tax}{\code{(character)} Variable name of the occurring taxa (variable type: \code{factor} or \code{character} - such as \code{"genus"})}

\item{bin}{\code{(character)} Variable name of the bin numbers of the occurrences. This variable should be \code{numeric} and should increase as time passes by (use negative values for age estimates). The current version only supports discreet, non-negative integer interval numbers.}

\item{taxvars}{\code{(character)} Taxon-specific column names of the variables that should be included in the output table. Only one entry/taxon is used, make sure that the data are clean.}

\item{rt}{\code{(logical)} Should the range-through assumption be applied within the function? If set to \code{TRUE} then missing occurrences will be interpolated with \code{FALSE} values in both the \code{ext} and \code{ori} variables. .}

\item{singletons}{\code{(logical)} Should single-interval taxa be removed from the final table? This is recommended, as it is impossible to get a \code{FALSE} response for these taxa.}
}
\description{
This function takes an occurrence dataset and reformats it to a table that can be used as input for logistic models.
}
\details{
Every entry in the output table corresponds to one cell in the \code{bin}/\code{tax} matrix. This function omits duplicates and concatenates two \code{logical} vectors (response variables) to the occurrence dataset:  
The \code{ori} vector is \code{TRUE} in the interval when the taxon first appeared, and \code{FALSE} in all others. The \code{ext} vector is \code{TRUE} in the interval the taxon appeared for the last time, and \code{FALSE} in the rest.
}
\examples{
# load necessary data
data(corals)
# simple table
modTab<-modeltab(corals, bin="stg", tax="genus", taxvars=c("ecology", "family"))

}
