% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atkinson.R
\name{ds_atkinson}
\alias{ds_atkinson}
\alias{atkinson}
\title{Compute Atkinson b Index}
\usage{
ds_atkinson(.data, .cols, .name, b = 0.5)

atkinson(..., .data = dplyr::cur_data_all())
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble}}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with Atkinson b index. Leave missing to return a vector.}

\item{b}{Default 0.5. Exponent parameter b, where 0 <= b <= 1.}

\item{...}{arguments to forward to ds_atkinson from atkinson}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Atkinson b Index
}
\examples{
data('de_county')
ds_atkinson(de_county, c(pop_white, starts_with('pop_')))
ds_atkinson(de_county, starts_with('pop_'), 'atkinson')
}
\concept{evenness}
