% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_s4.R
\name{to_s4}
\alias{to_s4}
\alias{to_df}
\title{Change the returned outputs of \code{diyar} functions}
\usage{
to_s4(df)

to_df(s4)
}
\arguments{
\item{df}{\code{data.frame}}

\item{s4}{\link[=pid-class]{pid} or \link[=epid-class]{epid} objects}
}
\value{
to_s4 - \link[=pid-class]{pid} or \link[=epid-class]{epid} objects

to_df - \code{data.frame} object
}
\description{
Convert the returned output of \code{\link{number_line}}, \code{\link{record_group}}, \code{\link{episode_group}}, \code{\link{fixed_episodes}} and \code{\link{rolling_episodes}}
from a \code{data.frame} to \link[=number_line-class]{number_line}, \link[=pid-class]{pid} or \link[=epid-class]{epid} objects, and vice versa.
}
\examples{
data(infections)
dates <- infections$date
output <- fixed_episodes(dates, case_length=30)
output

# from the a pid/epid object to a data.frame
df_output <- to_df(output)
df_output

# from a data.frame to pid/epid object
s4_output <- to_s4(df_output)
s4_output

all(s4_output == output)

}
