% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/episodes.R
\name{episodes}
\alias{episodes}
\title{Link events to chronological episodes.}
\usage{
episodes(
  date,
  case_length = Inf,
  episode_type = "fixed",
  recurrence_length = case_length,
  episode_unit = "days",
  strata = NULL,
  sn = NULL,
  episodes_max = Inf,
  rolls_max = Inf,
  case_overlap_methods = 8,
  recurrence_overlap_methods = case_overlap_methods,
  skip_if_b4_lengths = FALSE,
  data_source = NULL,
  data_links = "ANY",
  custom_sort = NULL,
  skip_order = Inf,
  reference_event = "last_record",
  case_for_recurrence = FALSE,
  from_last = FALSE,
  group_stats = FALSE,
  display = "none",
  case_sub_criteria = NULL,
  recurrence_sub_criteria = case_sub_criteria,
  case_length_total = 1,
  recurrence_length_total = case_length_total,
  skip_unique_strata = TRUE
)
}
\arguments{
\item{date}{\code{[date|datetime|integer|\link{number_line}]}. Event date or period.}

\item{case_length}{\code{[integer|\link{number_line}]}. Duration from index event distinguishing one \code{"Case"} from another.}

\item{episode_type}{\code{[character]}. Options are \code{"fixed"} (default), \code{"rolling"} or \code{"recursive"}. See \code{Details}.}

\item{recurrence_length}{\code{[integer|\link{number_line}]}. Duration from an event distinguishing a \code{"Recurrent"} event from its index event.}

\item{episode_unit}{\code{[character]}. Time units for \code{case_length} and \code{recurrence_length}. Options are "seconds", "minutes", "hours", "days" (default), "weeks", "months" or "years". See \code{diyar::episode_unit}.}

\item{strata}{\code{[atomic]}. Subsets of the dataset. Episodes are created separately for each \code{strata}.}

\item{sn}{\code{[integer]}. Unique record identifier. Useful for creating familiar \code{\link[=epid-class]{epid}} identifiers.}

\item{episodes_max}{\code{[integer]}. The maximum number of episodes permitted within each \code{strata}.}

\item{rolls_max}{\code{[integer]}. Maximum number of times the index event recurs. Only used if \code{episode_type} is \code{"rolling"} or \code{"recursive"}.}

\item{case_overlap_methods}{\code{[character|integer]}. Accepted overlaps method for \code{"Case"} and \code{"Duplicate"} events. Relevant when \code{date} is a period (\link{number_line}). See (\code{\link{overlaps}}).}

\item{recurrence_overlap_methods}{\code{[character|integer]}. Accepted overlaps method for \code{"Recurrent"} and \code{"Duplicate"} events. Relevant when \code{date} is a period (\link{number_line}). See (\code{\link{overlaps}}).}

\item{skip_if_b4_lengths}{\code{[logical]}. If \code{TRUE} (default), events before a lagged \code{case_length} or \code{recurrence_length} are skipped.}

\item{data_source}{\code{[character]}. Data source identifier. Adds the list of data sources in each episode to the \code{\link[=epid-class]{epid}}. Useful when the data is from multiple sources.}

\item{data_links}{\code{[list|character]}. A set of \code{data_sources} required in each \code{\link[=epid-class]{epid}}. A record-group without records from these \code{data_sources} will be \code{\link[=delink]{unlinked}}. See \code{Details}.}

\item{custom_sort}{\code{[atomic]}. Preferential order for selecting index events. See \code{\link{custom_sort}}.}

\item{skip_order}{\code{[integer]}. \code{"nth"} level of \code{custom_sort}. Episodes with index events beyond this level of preference are skipped.}

\item{reference_event}{\code{[character]}. Specifies which events are used as index events for a subsequent \code{case_length} or \code{recurrence_length}. Options are \code{"last_record"} (default), \code{"last_event"}, \code{"first_record"} or \code{"first_event"}.}

\item{case_for_recurrence}{\code{[logical]}. If \code{TRUE}, both \code{"Case"} and \code{"Recurrent"} events will have a \code{case_length}.
If \code{FALSE} (default), only \code{case events} will have a \code{case window}. Only used if \code{episode_type} is \code{"rolling"} or \code{"recursive"}.}

\item{from_last}{\code{[logical]}. Chronological order of episode tracking i.e. ascending (\code{TRUE}) or descending (\code{FALSE}).}

\item{group_stats}{\code{[logical]}. If \code{TRUE} (default), episode-specific information like episode start and end dates are returned.}

\item{display}{\code{[character]}. Display or produce a status update. Options are; \code{"none"} (default), \code{"progress"}, \code{"stats"}, \code{"none_with_report"}, \code{"progress_with_report"} or \code{"stats_with_report"}.}

\item{case_sub_criteria}{\code{[\link{sub_criteria}]}. Additional matching criteria for events in a \code{case_length}.}

\item{recurrence_sub_criteria}{\code{[\link{sub_criteria}]}. Additional matching criteria for events in a \code{recurrence_length}.}

\item{case_length_total}{\code{[integer|\link{number_line}]}. Minimum number of matched \code{case_lengths} required for an episode.}

\item{recurrence_length_total}{\code{[integer|\link{number_line}]}. Minimum number of matched \code{recurrence_lengths} required for an episode.}

\item{skip_unique_strata}{\code{[logical]}. If \code{TRUE}, a strata with a single event are skipped.}
}
\value{
\code{\link[=epid-class]{epid}}; \code{list}
}
\description{
Create temporal links between dated events.
Each set of linked records are assigned a unique identifier with relevant group-level information.
}
\details{
\bold{\code{episodes()}} links dated records (events) that
are within specified durations of each other.
In each iteration, an index event is selected and compared against every other event.

Every event is linked to a unique group (episode; \code{\link[=epid-class]{epid}} object).
These episodes represent occurrences of interest as defined by the rules and conditions specified in the function's arguments.

By default, this process occurs in ascending order; beginning with the earliest event and proceeding to the most recent one.
This can be changed to a descending (\code{from_last}) or custom order (\code{custom_sort}).
Ties are always broken by the chronological order of events.

In general, three type of episodes are possible;
\itemize{
\item \code{"fixed"} - An episode where all events are within fixed durations of one index event.
\item \code{"rolling"} - An episode where all events are within recurring durations of one index event.
\item \code{"recursive"} - An episode where all events are within recurring durations of multiple index events.
}

Every event in each episode is categorise as;
\itemize{
\item \code{"Case"} - Index event of the episode (without matching \code{\link{sub_criteria}}).
\item \code{"Case_CR"} - Index event of the episode (with matching \code{\link{sub_criteria}}).
\item \code{"Duplicate_C"} - Duplicate of the index event.
\item \code{"Recurrent"} - Recurrence of the index event (without matching \code{\link{sub_criteria}}).
\item \code{"Recurrent_CR"} - Recurrence of the index event (with matching \code{\link{sub_criteria}}).
\item \code{"Duplicate_R"} - Duplicate of the recurrent event.
\item \code{"Skipped"} - Records excluded from the episode tracking process.
}

If \code{data_links} is supplied, every element of the list must be named \code{"l"} (links) or \code{"g"} (groups).
Unnamed elements are assumed to be \code{"l"}.
\itemize{
\item If named \code{"l"}, only groups with records from every listed \code{data_source} will be unlinked.
\item If named \code{"g"}, only groups with records from any listed \code{data_source} will be unlinked.
}

\emph{Records with a missing (\code{NA}) \code{strata} are excluded from the episode tracking process.}

See \code{vignette("episodes")} for further details.
}
\examples{
data(infections); db_1 <- infections
data(hospital_admissions) ; db_2 <- hospital_admissions

db_1$patient_id <- c(rep("PID 1",8), rep("PID 2",3))

# Fixed episodes
# One 16-day (15-day difference) episode per patient
db_1$ep1 <- episodes(date = db_1$date,
                     strata = db_1$patient_id,
                     case_length = 15,
                     episodes_max = 1)
# Rolling episodes
# 16-day episodes with recurrence periods of 11 days
db_1$ep2 <- episodes(date = db_1$date,
                     case_length = 15,
                     recurrence_length = 10,
                     episode_type = "rolling")

# Interval grouping
db_2$admin_period <- number_line(db_2$admin_dt,
                                 db_2$discharge_dt)
# Episodes of hospital stays
db_2$ep3 <- episodes(date = db_2$admin_period,
                     case_length = index_window(db_2$admin_period),
                     case_overlap_methods = "inbetween")

}
\seealso{
\code{\link{episodes_wf_splits}}; \code{\link{custom_sort}}; \code{\link{sub_criteria}}; \code{\link[=windows]{epid_length}}; \code{\link[=windows]{epid_window}}; \code{\link{partitions}}; \code{\link{links}}; \code{\link{overlaps}}; \code{\link{number_line}}; \code{\link{link_records}}; \code{\link{schema}}
}
