% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bys_funcs.R
\name{bys_funcs}
\alias{bys_funcs}
\alias{bys_count}
\alias{bys_rank}
\alias{bys_position}
\alias{bys_val}
\alias{bys_nval}
\alias{bys_min}
\alias{bys_max}
\alias{bys_sum}
\alias{bys_prod}
\alias{bys_cummin}
\alias{bys_cummax}
\alias{bys_cumsum}
\alias{bys_cumprod}
\alias{bys_lag}
\alias{bys_lead}
\title{Vectorised approach to group operations.}
\usage{
bys_count(by)

bys_rank(..., by = NULL, from_last = FALSE)

bys_position(val, by = NULL, from_last = FALSE, ordered = TRUE)

bys_val(..., val, by = NULL, from_last = FALSE)

bys_nval(..., val, by = NULL, from_last = FALSE, n = 1, nmax = FALSE)

bys_min(val, by = NULL, na.rm = TRUE)

bys_max(val, by = NULL, na.rm = TRUE)

bys_sum(val, by = NULL, na.rm = TRUE)

bys_prod(val, by = NULL, na.rm = TRUE)

bys_cummin(val, by = NULL, na.rm = TRUE)

bys_cummax(val, by = NULL, na.rm = FALSE)

bys_cumsum(val, by = NULL, na.rm = TRUE)

bys_cumprod(val, by = NULL, na.rm = TRUE)

bys_lag(val, by = NULL, n = 1)

bys_lead(val, by = NULL, n = 1)
}
\arguments{
\item{by}{\code{[atomic]}. Groups.}

\item{...}{\code{[atomic]}. Sort levels}

\item{from_last}{\code{[logical]} Sort order - \code{TRUE} (descending) or \code{FALSE} (ascending).}

\item{val}{\code{[atomic]}. Value}

\item{ordered}{If \code{TRUE}, values are sequential.}

\item{n}{\code{[integer]} Position.}

\item{nmax}{\code{[logical]} If \code{TRUE}, use \code{length([by])} when \code{n} is greater than the number of records in a group.}

\item{na.rm}{If \code{TRUE}, remove \code{NA} values}
}
\value{
\code{[atomic]}
}
\description{
Vectorised approach to group operations.
}
\examples{
x <- data.frame(
  group = c(2, 2, 1, 2, 1, 1, 1, 2, 1, 1),
  value = c(13, 14, 20, 9, 2, 1, 8, 18, 3, 17))

bys_count(x$group)
bys_position(x$value, by = x$group, from_last = TRUE)
bys_rank(by = x$group, val = x$value, from_last = TRUE)
bys_val(x$value, by = x$group, val = x$value, from_last = TRUE)
bys_nval(x$value, by = x$group, val = x$value, from_last = TRUE, n = 2)
bys_min(by = x$group, val = x$value)
bys_max(by = x$group, val = x$value)
bys_sum(by = x$group, val = x$value)
bys_prod(by = x$group, val = x$value)
bys_cummin(by = x$group, val = x$value)
bys_cummax(by = x$group, val = x$value)
bys_cumsum(by = x$group, val = x$value)
bys_cumprod(by = x$group, val = x$value)
bys_lag(by = x$group, val = x$value)
bys_lead(by = x$group, val = x$value)
}
