% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_s4_ids.R
\name{make_s4_ids}
\alias{make_s4_ids}
\alias{make_episodes}
\alias{make_pids}
\title{Create \code{epid} and \code{pid} objects with index of matching records}
\usage{
make_episodes(
  x_pos,
  y_pos,
  x_val,
  date,
  case_nm,
  wind_id,
  wind_nm,
  from_last,
  data_source,
  data_links,
  iteration,
  options,
  episode_unit
)

make_pids(
  x_pos,
  y_pos,
  x_val,
  link_id,
  pid_cri,
  data_source,
  data_links,
  iteration
)
}
\arguments{
\item{x_pos}{\code{[integer]}. Index of one half of a record pair.}

\item{y_pos}{\code{[integer]}. Index of one half of a record pair.}

\item{x_val}{\code{[integer]}. Value of one half of a record pair.}

\item{date}{\code{[date|datetime|integer|\link{number_line}]}. Record date or period.}

\item{case_nm}{\code{[integer|character]} Record type in regards to case assignment (\code{\link{sub_criteria}[Encoded]}).}

\item{wind_id}{\code{[integer]}. Unique reference ID for each match.}

\item{wind_nm}{\code{[list]}. Type of window i.e. "Case" or "Recurrence".}

\item{from_last}{\code{[logical]}. Chronological order of episode tracking i.e. ascending (\code{TRUE}) or descending (\code{FALSE}).}

\item{data_source}{\code{[character]}. Source ID for each record.}

\item{data_links}{\code{[list|character]}. \code{data_source} required in each record-group. A record-group without records from these \code{data_sources} will be \code{\link[=delink]{unlinked}}.}

\item{iteration}{The iteration when a record was matched to it's group (\code{.Data}).}

\item{options}{\code{[list]}. Some options passed to the instance of \code{\link{episodes}}.}

\item{episode_unit}{\code{[character]}. Time unit for \code{case_length} and \code{recurrence_length}. See \code{\link{episodes}}}

\item{link_id}{\code{[integer]}. Unique reference ID for each match.}

\item{pid_cri}{Match stage of the step-wise linkage.}
}
\description{
Create \code{epid} and \code{pid} objects with index of matching records
}
