#' create_node
#'
#' Create a DKAN node
#'
#' @param url character: The DKAN site URL
#' @param body json: A JSON object to be passed to the body of the request
#' @param credentials Optional list parameter. Default values are Cookie and Token generated by dkan_setup()
#' @param as character: Output format. Options are: 'json' or 'list'
#' @param ... Other optional parameters passed to the underlying GET request
#'
#' @return dkan_node object
#' @export
#'
#' @examples
#' \dontrun{
#' create_node(url = "http://demo.getdkan.com", body = {"title": "TEST DATASET"})
#' }

create_node <- function(url = get_url(),
                        body,
                        credentials = list(cookie = dkanr::get_cookie(),
                                           token = dkanr::get_token()),
                        as = "json", ...) {
  res <- dkan_POST(url = url, body = body, credentials = credentials, ...)
  switch(as, json = res, list = as_dk(jsl(res), "dkan_node"))
}
