% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.sim_dlim.R
\name{predict.sim_dlim}
\alias{predict.sim_dlim}
\title{Simulated DLIM Predictions}
\usage{
\method{predict}{sim_dlim}(object, newdata = NULL, type = c("DLF", "CE", "response"), ...)
}
\arguments{
\item{object}{an object of class "\code{dlim}"}

\item{newdata}{vector of modifiers for inference (class "\code{numeric}")}

\item{type}{Type of prediction. "response" for predicted responses, "DLF" for the estimated distributed lag functions, "CE" for cumulative effects (class "\code{character}")}

\item{...}{additional arguments affecting the predictions produced}
}
\value{
This function returns a list of 4 or 7 elements:
\item{est_dlim}{\code{est_dlim} element from \code{predict.dlim} (class "\code{list}")}
\item{cb}{cross-bais from \code{object} (class "\code{cross-basis}")}
\item{fit}{\code{fit} from \code{object} (class "\code{lm}", "\code{glm}", "\code{gam}")}
\item{true_betas}{\code{true_betas} from \code{object} (class "\code{matrix}")}
\item{cb_dlm}{\code{cb_dlm} from \code{object} (class "\code{crosspred}")}
\item{model_dlm}{\code{model_dlm} from \code{object} (class "\code{lm}", "\code{glm}", "\code{gam}")}
\item{est_dlm}{cumulative and/or point-wise estimates, standard errors, and confidence intervals for the DLM (class "\code{list}")}
}
\description{
This function estimates cumulative and non-cumulative lag/modifier coefficients from a model in which the response is regressed on a cross-basis generated by the \code{cross_basis()} function.
}
\seealso{
\link[dlim]{predict.dlim}

Type \code{vignette('dlimOverview')} for a detailed description.
}
