% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{diagnose_report}
\alias{diagnose_report}
\alias{diagnose_report.data.frame}
\title{Reporting the information of data diagnosis}
\usage{
diagnose_report(.data, output_format, output_file, output_dir, ...)

\method{diagnose_report}{data.frame}(
  .data,
  output_format = c("pdf", "html"),
  output_file = NULL,
  output_dir = tempdir(),
  font_family = NULL,
  browse = TRUE,
  ...
)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{output_format}{report output type. Choose either "pdf" and "html".
"pdf" create pdf file by knitr::knit().
"html" create html file by rmarkdown::render().}

\item{output_file}{name of generated file. default is NULL.}

\item{output_dir}{name of directory to generate report file. default is tempdir().}

\item{...}{arguments to be passed to methods.}

\item{font_family}{charcter. font family name for figure in pdf.}

\item{browse}{logical. choose whether to output the report results to the browser.}
}
\description{
The diagnose_report() report the information for diagnosing
the quality of the data.
}
\details{
Generate generalized data diagnostic reports automatically.
You can choose to output to pdf and html files.
This is useful for diagnosing a data frame with a large number of variables
than data with a small number of variables.
For pdf output, Korean Gothic font must be installed in Korean operating system.
}
\section{Reported information}{

Reported from the data diagnosis is as follows.

\itemize{
  \item Diagnose Data
  \itemize{
    \item Overview of Diagnosis
    \itemize{
      \item List of all variables quality
      \item Diagnosis of missing data
      \item Diagnosis of unique data(Text and Category)
      \item Diagnosis of unique data(Numerical)
    }
    \item Detailed data diagnosis
    \itemize{
      \item Diagnosis of categorical variables
      \item Diagnosis of numerical variables
      \item List of numerical diagnosis (zero)
      \item List of numerical diagnosis (minus)
    }
  }
  \item Diagnose Outliers
  \itemize{
    \item Overview of Diagnosis
    \itemize{
      \item Diagnosis of numerical variable outliers
      \item Detailed outliers diagnosis
    }
  }
}

See vignette("diagonosis") for an introduction to these concepts.
}

\examples{
\donttest{
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# reporting the diagnosis information -------------------------
# create pdf file. file name is DataDiagnosis_Report.pdf
diagnose_report(carseats)
# create pdf file. file name is Diagn.pdf
diagnose_report(carseats, output_file = "Diagn.pdf")
# create pdf file. file name is ./Diagn.pdf and not browse
diagnose_report(carseats, output_dir = ".", output_file = "Diagn.pdf", 
  browse = FALSE)
# create html file. file name is Diagnosis_Report.html
diagnose_report(carseats, output_format = "html")
# create html file. file name is Diagn.html
diagnose_report(carseats, output_format = "html", output_file = "Diagn.html")
}

}
