% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{extract}
\alias{extract}
\alias{extract.bins}
\title{Extract bins from "bins"}
\usage{
extract(x)

\method{extract}{bins}(x)
}
\arguments{
\item{x}{a bins class or optimal_bins class.}
}
\value{
factor.
}
\description{
The extract() extract binned variable from "bins", "optimal_bins" class object.
}
\details{
The "bins" and "optimal_bins" class objects use the summary() and plot() functions to diagnose 
the performance of binned results. This function is used to extract the binned result if you are satisfied 
with the result.
}
\examples{
# Generate data for the example
library(dplyr)

carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# optimal binning
bin <- binning_by(carseats, "US", "Advertising")
bin

# summary optimal_bins class
summary(bin)

# visualize all information for optimal_bins class
# plot(bin)

# extract binning result
# extract(bin) \%>\% 
#   head(20)

}
\seealso{
\code{\link{binning}}, \code{\link{binning_by}}.
}
