% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{plot_normality.tbl_dbi}
\alias{plot_normality.tbl_dbi}
\title{Plot distribution information of numerical data}
\usage{
\method{plot_normality}{tbl_dbi}(
  .data,
  ...,
  in_database = FALSE,
  collect_size = Inf,
  left = c("log", "sqrt", "log+1", "1/x", "x^2", "x^3", "Box-Cox", "Yeo-Johnson"),
  right = c("sqrt", "log", "log+1", "1/x", "x^2", "x^3", "Box-Cox", "Yeo-Johnson"),
  col = "steelblue",
  typographic = TRUE
)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_normality() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.

See vignette("EDA") for an introduction to these concepts.}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory. Not yet supported in_database = TRUE.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.}

\item{left}{character. Specifies the data transformation method to draw the histogram in the 
lower left corner. The default is "log".}

\item{right}{character. Specifies the data transformation method to draw the histogram in the 
lower right corner. The default is "sqrt".}

\item{col}{a color to be used to fill the bars. The default is "steelblue".}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization.}
}
\description{
The plot_normality() visualize distribution information
for normality test of the numerical(INTEGER, NUMBER, etc.) column of 
the DBMS table through tbl_dbi.
}
\details{
The scope of the visualization is the provide a distribution information.
Since the plot is drawn for each variable, if you specify more than
one variable in the ... argument, the specified number of plots are drawn.

The argument values that left and right can have are as follows.:

\itemize{
  \item "log" : log transformation. log(x)
  \item "log+1" : log transformation. log(x + 1). Used for values that contain 0.
  \item "sqrt" : square root transformation.
  \item "1/x" : 1 / x transformation
  \item "x^2" : x square transformation
  \item "x^3" : x^3 square transformation
  \item "Box-Cox" : Box-Box transformation
  \item "Yeo-Johnson" : Yeo-Johnson transformation
}
}
\section{Distribution information}{

The plot derived from the numerical data visualization is as follows.

\itemize{
\item histogram by original data
\item q-q plot by original data
\item histogram by log transfer data
\item histogram by square root transfer data
}
}

\examples{
\donttest{
library(dplyr)

# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy carseats to the DBMS with a table named TB_CARSEATS
copy_to(con_sqlite, carseats, name = "TB_CARSEATS", overwrite = TRUE)

# Using pipes ---------------------------------
# Visualization of all numerical variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  plot_normality()

# Positive values select variables, and In-memory mode and collect size is 200
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  plot_normality(Income, Price, collect_size = 200)

# Positions values select variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  plot_normality(1)

# Not allow the typographic elements
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  plot_normality(1, typographic = FALSE)
  
# Using pipes & dplyr -------------------------
# Plot 'Sales' variable by 'ShelveLoc' and 'US'
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  group_by(ShelveLoc, US) \%>\%
  plot_normality(Sales)

# Plot using left and right arguments
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  group_by(ShelveLoc, US) \%>\%
  plot_normality(Sales, left = "Box-Cox", right = "log")

# extract only those with 'ShelveLoc' variable level is "Good",
# and plot 'Income' by 'US'
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  filter(ShelveLoc == "Good") \%>\%
  group_by(US) \%>\%
  plot_normality(Income)
}

}
\seealso{
\code{\link{plot_normality.data.frame}}, \code{\link{plot_outlier.tbl_dbi}}.
}
