% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{plot_na_intersect}
\alias{plot_na_intersect}
\title{Plot the combination variables that is include missing value}
\usage{
plot_na_intersect(
  x,
  only_na = TRUE,
  n_intersacts = NULL,
  n_vars = NULL,
  main = NULL,
  typographic = TRUE,
  base_family = NULL
)
}
\arguments{
\item{x}{data frames, or objects to be coerced to one.}

\item{only_na}{logical. The default value is FALSE. 
If TRUE, only variables containing missing values are selected for visualization. 
If FALSE, included complete case.}

\item{n_intersacts}{integer. Specifies the number of combinations of variables including missing values. 
The combination of variables containing many missing values is chosen first.}

\item{n_vars}{integer. Specifies the number of variables that contain missing values to be visualized. 
The default value is NULL, which visualizes variables containing all missing values. 
If this value is greater than the number of variables containing missing values, 
all variables containing missing values are visualized. Variables containing many missing values are chosen first.}

\item{main}{character. Main title.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}
}
\description{
Visualize the combinations of missing value across cases.
}
\details{
The visualization consists of four parts.
The bottom left, which is the most basic, visualizes the case of cross(intersection)-combination. 
The x-axis is the variable including the missing value, and the y-axis represents the case of a combination of variables.
And on the marginal of the two axes, the frequency of the case is expressed as a bar graph. 
Finally, the visualization at the top right expresses the number of variables including missing values in the data set, 
and the number of observations including missing values and complete cases .

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
# Generate data for the example
set.seed(123L)
jobchange2 <- jobchange[sample(nrow(jobchange), size = 1000), ]

# Visualize the combination variables that is include missing value.
plot_na_intersect(jobchange2)

# Diagnose the data with missing_count using diagnose() function
library(dplyr)

jobchange2 \%>\% 
  diagnose \%>\% 
  arrange(desc(missing_count))

# Visualize the combination variables that is include missing value
plot_na_intersect(jobchange2)

# Visualize variables containing missing values and complete case
plot_na_intersect(jobchange2, only_na = FALSE)

# Using n_vars argument
plot_na_intersect(jobchange2, n_vars = 5) 

# Using n_intersects argument
plot_na_intersect(jobchange2, only_na = FALSE, n_intersacts = 7)

# Not allow typographic elements
# plot_na_intersect(jobchange2, typographic = FALSE)

}
