% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{univar_numeric}
\alias{univar_numeric}
\alias{univar_numeric.data.frame}
\title{Statistic of univariate numerical variables}
\usage{
univar_numeric(.data, ...)

\method{univar_numeric}{data.frame}(.data, ...)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}
}
\value{
An object of the class as individual variables based list.
A component named "statistics" is a tibble object with the following statistics.:
\itemize{
\item variable : factor. The level of the variable. 'variable' is the name of the variable.
\item n : number of observations excluding missing values
\item na : number of missing values
\item mean : arithmetic average
\item sd : standard deviation
\item se_mean : standrd error mean. sd/sqrt(n)
\item IQR : interquartile range (Q3-Q1)
\item skewness : skewness
\item kurtosis : kurtosis
\item median : median. 50\% percentile
}
}
\description{
The univar_numeric() calculates statistic of numerical variables that is frequency table
}
\details{
univar_numeric() calculates the popular statistics of  numerical variables. 
If a specific variable name is not specified, statistics for all categorical numerical included in the data are calculated.
The statistics obtained by univar_numeric() are part of those obtained by describe(). 
Therefore, it is recommended to use describe() to simply calculate statistics. 
However, if you want to visualize the distribution of individual variables, you should use univar_numeric().
}
\section{Attributes of return object}{

Attributes of compare_category class is as follows.
\itemize{
\item raw : a data.frame or a \code{\link{tbl_df}}. Data containing variables to be compared. Save it for visualization with plot.univar_numeric().
\item variables : character. List of variables selected for calculate statistics.
}
}

\examples{
\donttest{
# Calculates the all categorical variables
all_var <- univar_numeric(heartfailure)

# Print univar_numeric class object
all_var

# Calculates the platelets, sodium variable
univar_numeric(heartfailure, platelets, sodium)

# Summary the all case : Return a invisible copy of an object.
stat <- summary(all_var)

# Summary by returned object
stat

# Statistics of numerical variables normalized by Min-Max method
summary(all_var, stand = "minmax")

# Statistics of numerical variables standardized by Z-score method
summary(all_var, stand = "zscore")

# one plot with all variables
plot(all_var)

# one plot with all normalized variables by Min-Max method
plot(all_var, stand = "minmax")

# one plot with all variables
plot(all_var, stand = "none")

# one plot with all robust standardized variables 
plot(all_var, viz = "boxplot")

# one plot with all standardized variables by Z-score method 
plot(all_var, viz = "boxplot", stand = "zscore")

# individual boxplot by variables
plot(all_var, indiv = TRUE, "boxplot")

# individual histogram by variables
plot(all_var, indiv = TRUE, "hist")

# individual histogram by robust standardized variable 
plot(all_var, indiv = TRUE, "hist", stand = "robust")

# plot all variables by prompt
plot(all_var, indiv = TRUE, "hist", prompt = TRUE)
}

}
\seealso{
\code{\link{summary.univar_numeric}}, \code{\link{print.univar_numeric}}, \code{\link{plot.univar_numeric}}.
}
