% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{summary.optimal_bins}
\alias{summary.optimal_bins}
\title{Summarizing Performance for Optimal Bins}
\usage{
\method{summary}{optimal_bins}(object, ...)
}
\arguments{
\item{object}{an object of class "optimal_bins", usually, a result of a call to binning_by().}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
NULL.
}
\description{
summary method for "optimal_bins". summary metrics to evaluate the performance 
of binomial classification model.
}
\details{
print() to print only binning table information of "optimal_bins" objects.
summary.performance_bin() includes general metrics and result of significance tests life follows.:
\itemize{
  \item Binning Table : Metrics by bins.
  \itemize{
    \item CntRec, CntPos, CntNeg, RatePos, RateNeg, Odds, WoE, IV, JSD, AUC.
  }
  \item General Metrics.
  \itemize{
    \item Gini index.
    \item Jeffrey's Information Value.
    \item Jensen-Shannon Divergence.
    \item Kolmogorov-Smirnov Statistics.
    \item Herfindahl-Hirschman Index.
    \item normalized Herfindahl-Hirschman Index.
    \item Cramer's V Statistics.
  } 
  \item Table of Significance Tests.
}
}
\examples{
library(dplyr)

# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "creatinine"] <- NA

# optimal binning
bin <- binning_by(heartfailure2, "death_event", "creatinine")
bin

# summary optimal_bins class
summary(bin)

# performance table
attr(bin, "performance")

# extract binned results
if (!is.null(bin)) {
  extract(bin) \%>\% 
    head(20)
}

}
\seealso{
\code{\link{binning_by}}, \code{\link{plot.optimal_bins}}
}
