% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_gui.R
\name{dm_gui}
\alias{dm_gui}
\title{Shiny app for defining dm objects}
\usage{
dm_gui(..., dm = NULL, select_tables = TRUE, debug = FALSE)
}
\arguments{
\item{...}{These dots are for future extensions and must be empty.}

\item{dm}{An initial dm object, currently required.}

\item{select_tables}{Show selectize input to select tables?}

\item{debug}{Set to \code{TRUE} to simplify debugging of the app.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function starts a Shiny application that allows to define \code{dm} objects
from a database or from local data frames.
The application generates R code that can be inserted or copy-pasted
into an R script or function.
}
\details{
In a future release, the app will also allow composing \code{dm} objects directly
from database connections or data frames.

The signature of this function is subject to change without notice.
This should not pose too many problems, because it will usually be run
interactively.
}
\examples{
\dontrun{
dm <- dm_nycflights13(cycle = TRUE)
dm_gui(dm = dm)
}
}
