% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{dmbc_get_configuration}
\alias{dmbc_get_configuration}
\title{Extractor function for a fitted DMBC model.}
\usage{
dmbc_get_configuration(res, chain = 1, est = "mean", labels = character(0))
}
\arguments{
\item{res}{An object of class \code{dmbc_fit_list}.}

\item{chain}{A length-one numeric vector indicating the MCMC chain number
to use.}

\item{est}{A length-one character vector indicating the estimate type to use.}

\item{labels}{An optional character vector with the object labels.}
}
\value{
A \code{\link{dmbc_config}} object.
}
\description{
\code{dmbc_get_configuration()} is an extractor function for extracting the
  latent configuration estimates of a fitted DMBC model.
}
\examples{
\dontrun{
data(simdiss, package = "dmbc")

G <- 3
p <- 2
prm.prop <- list(z = 1.5, alpha = .75)
burnin <- 2000
nsim <- 1000
seed <- 2301

set.seed(seed)

control <- list(burnin = burnin, nsim = nsim, z.prop = prm.prop[["z"]],
  alpha.prop = prm.prop[["alpha"]], random.start = TRUE, verbose = TRUE,
  nchains = 2, thin = 10, store.burnin = TRUE, threads = 2,
  parallel = "snow")
sim.dmbc <- dmbc(simdiss, p, G, control)

z <- dmbc_get_configuration(sim.dmbc, chain = 1, est = "mean")
summary(z)

library(bayesplot)
library(ggplot2)
color_scheme_set("mix-pink-blue")
graph <- plot(z, size = 2, size_lbl = 3)
graph + panel_bg(fill = "gray90", color = NA)
}
}
\references{
Venturini, S., Piccarreta, R. (2019), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Technical report.
}
\seealso{
\code{\link{dmbc_data}} for a description of the data format.

\code{\link{dmbc_fit_list}} for a description of the elements
  included in the returned object.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
