dmesolve <-
function (mdf, fixform = Ymat ~ 1, components = c("VarE(I)", 
    "VarG(Ia)"), specific.components = NULL, cohortform = NULL, 
    posdef = T, fixedgls = F, fixedglsopt = list(maxiter = 200, 
        bdamp = 0.8, stoptol = 0.01), dmefglsopt = list(maxiter = 100, 
        bdamp = 0.8, stoptol = 0.001), dmeopt = "qr", ncomp.pcr = "rank", 
    relmat = "inline", dmekeep = F, dmekeepfit = F) 
{
    ctable <- make.ctable()
    if (any(is.na(match(components, ctable$all)))) {
        print(components)
        stop("Component(s) not recognized:\n")
    }
    if (!is.null(specific.components)) {
        for (i in 1:length(specific.components)) {
            if (any(is.na(match(specific.components[[i]], ctable$all)))) {
                print(specific.components[i])
                stop("Component(s) not recognized:\n")
            }
        }
    }
    if (!is.null(specific.components)) {
        for (i in 1:length(specific.components)) {
            if (any(!is.na(match(specific.components[[i]], components)))) {
                cat("Components = ")
                print(components)
                cat(" clashes with specific component = ")
                print(specific.components[i])
                stop("A component can not be both nonspecific and class specific\n")
            }
        }
    }
    if (is.null(mdf$rel)) {
        df <- mdf
        cat("Data file is a normal dataframe:\n")
        if (relmat == "withdf") {
            stop("dmm: cant have 'relmat=withdf' option for a normal dataframe\n")
        }
    }
    else {
        df <- mdf$df
        cat("Data file is a list containing a dataframe and a list of relationship matrices:\n")
    }
    cat("Random effect partitioned into components: Residual:\n")
    fixed.aov <- aov(fixform, df, x = T, y = T, qr = T)
    cat("OLS-fixed-effects step:\n")
    k <- ncol(fixed.aov$x)
    l <- ncol(as.matrix(fixed.aov$y))
    cat("no of fixed effect df (k) = ", k, "\n")
    cat("no of traits (l) = ", l, "\n")
    aov.list <- list(aov = fixed.aov, mdf = substitute(mdf), 
        fixform = fixform)
    ccount <- 0
    if (any(!is.na(match(components, ctable$cohort)))) {
        ccount <- ccount + 1
    }
    effnames <- names(specific.components)
    for (kf in 1:length(effnames)) {
        if (any(!is.na(match(specific.components[[kf]], ctable$cohort)))) {
            ccount <- ccount + 1
        }
    }
    if (ccount > 0) {
        cohortlabs <- attributes(terms(cohortform))$term.labels
        celabs <- c("DId", cohortlabs)
        cohortparts <- match(cohortlabs, colnames(df))
        ceparts <- match(celabs, colnames(df))
    }
    else {
        ceparts <- NULL
        cohortparts <- NULL
        celabs <- "DId"
        cohortlabs = NULL
    }
    cat("Setup antemodel matrices:\n")
    am <- am.zandrel(mdf, df, k, l, as.matrix(fixed.aov$x), as.matrix(fixed.aov$y), 
        cohortparts, components, specific.components, relmat, 
        ctable)
    if (l == 1) {
        dimnames(am$y) <- list(NULL, as.character(terms(fixform)[[2]]))
    }
    cat("no of individuals in pedigree (m) = ", am$m, "\n")
    cat("no of individuals with data and X codes (n) = ", am$n, 
        "\n")
    am.list <- list(am = am, components = components, v = am$v, 
        cohortform = cohortform, cohortlabs = cohortlabs, celabs = celabs, 
        cohortparts = cohortparts, ceparts = ceparts)
    v <- am$v
    x.qr <- fixed.aov$qr
    b <- qr.coef(x.qr, am$y)
    krank <- x.qr$rank
    if (krank < am$k) {
        stop("Rank of X ", krank, " .ne. no of fixed effects ", 
            am$k, "\n")
    }
    cat("Rank of X:", x.qr$rank, "  No of Fixed Effects:", k, 
        "\n")
    ymxb <- am$y - am$x %*% b
    ssa <- t(ymxb) %*% ymxb
    degf <- am$n - am$k
    vara <- ssa/degf
    vb <- kronecker(vara, solve(t(qr.R(x.qr)) %*% qr.R(x.qr)), 
        make.dimnames = T)
    seb <- matrix(sqrt(diag(vb)), am$k, am$l, dimnames = dimnames(b))
    ols.fixed.list <- list(b = b, seb = seb, vara = vara, totn = am$n, 
        degf = degf)
    cat("OLS-fixed-effects step completed:\n")
    if (am$v == 0) {
        stop("No components defined:\n")
    }
    cat("DME substep:\n")
    evec <- kronecker(ymxb, ymxb, make.dimnames = T)
    mmat <- diag(am$n) - am$x %*% ginv(am$x)
    dyad.explist <- dyad.am.expect(am, fixedgls, dmeopt, mmat)
    am$v <- dyad.explist$newv
    degfd <- am$n * am$n - am$v
    if (dmekeep) {
        dme.exp.list <- list(dme.wmat = dyad.explist$emat, dme.psi = evec, 
            dme.mean = dyad.explist$emat.mean, dme.var = dyad.explist$emat.var, 
            dme.correl = dyad.explist$emat.cor)
    }
    else {
        dme.exp.list <- list(dme.mean = dyad.explist$emat.mean, 
            dme.var = dyad.explist$emat.var, dme.correl = dyad.explist$emat.cor)
    }
    if (!dyad.explist$fullrank) {
        ols.list <- c(aov.list, ols.fixed.list, dme.exp.list)
        return(ols.list)
    }
    if (dmeopt == "qr") {
        cat("QR option on dyadic model equations:\n")
        siga <- matrix(0, am$v, am$l * am$l, dimnames = list(colnames(dyad.explist$emat), 
            colnames(evec)))
        siga <- qr.coef(dyad.explist$emat.qr, evec)
        vard <- crossprod(qr.resid(dyad.explist$emat.qr, evec))
        vard <- vard/degfd
        vsiga <- kronecker(vard, solve(crossprod(qr.R(dyad.explist$emat.qr))), 
            make.dimnames = T)
        sesiga <- matrix(sqrt(diag(vsiga)), am$v, am$l * am$l, 
            dimnames = dimnames(siga))
        if (dmekeepfit) {
            dme.fit.list <- list(dme.fit = dyad.explist$emat.qr, 
                dmeopt = dmeopt)
        }
        else {
            dme.fit.list <- list(dmeopt = dmeopt)
        }
    }
    else if (dmeopt == "lm") {
        dme.lm <- lm(evec ~ -1 + ., as.data.frame(dyad.explist$emat), 
            x = T, y = T, qr = T)
        cat("LM option on dyadic model equations:\n")
        siga <- matrix(0, am$v, am$l * am$l, dimnames = list(colnames(dyad.explist$emat), 
            colnames(evec)))
        sesiga <- matrix(0, am$v, am$l * am$l, dimnames = dimnames(siga))
        if (am$l == 1) {
            siga[, 1] <- summary(dme.lm)$coef[, 1]
            sesiga[, 1] <- summary(dme.lm)$coef[, 2]
        }
        else {
            for (l2 in 1:(am$l * am$l)) {
                siga[, l2] <- summary(dme.lm)[[l2]]$coef[, 1]
                sesiga[, l2] <- summary(dme.lm)[[l2]]$coef[, 
                  2]
            }
        }
        vard <- crossprod(qr.resid(dme.lm$qr, evec))
        vard <- vard/degfd
        vsiga <- kronecker(vard, solve(crossprod(qr.R(dme.lm$qr))), 
            make.dimnames = T)
        if (dmekeepfit) {
            dme.fit.list <- list(dme.fit = dme.lm, dmeopt = dmeopt)
        }
        else {
            dme.fit.list <- list(dmeopt = dmeopt)
        }
    }
    else if (dmeopt == "lmrob") {
        if (am$l > 1) {
            stop("Lmrob option does not work in multivariate case:\n")
        }
        dme.lmrob <- lmrob(evec ~ -1 + ., as.data.frame(dyad.explist$emat), 
            x = T, y = T, qr = T)
        cat("LMROB option on dyadic model equations:\n")
        siga <- matrix(0, am$v, am$l * am$l, dimnames = list(colnames(dyad.explist$emat), 
            colnames(evec)))
        sesiga <- matrix(0, am$v, am$l * am$l, dimnames = dimnames(siga))
        if (am$l == 1) {
            siga[, 1] <- summary(dme.lmrob)$coef[, 1]
            sesiga[, 1] <- summary(dme.lmrob)$coef[, 2]
        }
        else {
            for (l2 in 1:(am$l * am$l)) {
                siga[, l2] <- summary(dme.lmrob)[[l2]]$coef[, 
                  1]
                sesiga[, l2] <- summary(dme.lmrob)[[l2]]$coef[, 
                  2]
            }
        }
        vard <- crossprod(qr.resid(dme.lmrob$qr, evec))
        vard <- vard/degfd
        vsiga <- kronecker(vard, solve(crossprod(qr.R(dme.lmrob$qr))), 
            make.dimnames = T)
        if (dmekeepfit) {
            dme.fit.list <- list(dme.fit = dme.lmrob, dmeopt = dmeopt)
        }
        else {
            dme.fit.list <- list(dmeopt = dmeopt)
        }
    }
    else if (dmeopt == "pcr") {
        if (ncomp.pcr == "all") {
            myncomp <- am$v
        }
        else if (ncomp.pcr == "rank") {
            myncomp <- dyad.explist$emat.qr$rank
        }
        else if (is.numeric(ncomp.pcr)) {
            myncomp <- min(am$v, ncomp.pcr)
        }
        else {
            stop("Invalid option ncomp.pcr: ", ncomp.pcr, "\n")
        }
        dme.pcr <- mvr(evec ~ -1 + ., ncomp = myncomp, data = as.data.frame(dyad.explist$emat), 
            method = "svdpc", validation = "CV", model = T, x = T, 
            y = T, jackknife = T)
        ncomp <- dme.pcr$ncomp
        cat("PCR option on dyadic model equations:\n")
        summary(dme.pcr)
        vsiga <- var.jack(dme.pcr, ncomp = myncomp, covariance = T)[, 
            , 1]
        siga <- matrix(0, am$v, am$l * am$l, dimnames = list(colnames(dyad.explist$emat), 
            colnames(evec)))
        siga <- matrix(coef(dme.pcr)[, , 1], am$v, am$l * am$l, 
            dimnames = list(colnames(dyad.explist$emat), colnames(evec)))
        sesiga <- matrix(sqrt(diag(vsiga)), am$v, am$l * am$l, 
            dimnames = dimnames(siga))
        residmat <- resid(dme.pcr)[, , ncomp]
        vard <- crossprod(residmat)
        vard <- vard/degfd
        if (dmekeepfit) {
            dme.fit.list <- list(dme.fit = dme.pcr, dmeopt = dmeopt)
        }
        else {
            dme.fit.list <- list(pcr.loadings = loadings(dme.pcr), 
                dmeopt = dmeopt)
        }
    }
    else if (dmeopt == "fgls") {
        if (am$l > 1) {
            cat("Note: Feasable GLS with multivariate data is not fully tested \n")
        }
        siga <- qr.coef(dyad.explist$emat.qr, evec)
        cat("fgls iteration starting siga from ols:\n")
        print(siga)
        vard <- crossprod(qr.resid(dyad.explist$emat.qr, evec))
        vard <- vard/(degfd)
        cat("Residual var for DME (vard):\n")
        print(vard)
        vart <- crossprod(evec, evec)/degfd
        cat("Total var for DME (vart):\n")
        print(vart)
        dme.fgls <- fgls.iter.siga(am, siga, mmat, dyad.explist, 
            evec, dmefglsopt, dmeopt, ctable)
        siga <- dme.fgls$siga
        vsigabase <- dme.fgls$vsiga
        vsiga <- kronecker(vard, vsigabase, make.dimnames = T)
        sesiga <- dme.fgls$sesiga
        if (dmekeepfit) {
            dme.fit.list <- list(dme.fit = dme.fgls, dmeopt = dmeopt)
        }
        else {
            dme.fit.list <- list(dmeopt = dmeopt)
        }
    }
    else {
        stop("Invalid dmeopt option:", dmeopt, "\n")
    }
    nsf <- length(specific.components)
    if (nsf == 0) {
        if (posdef) {
            siga <- siga.posdef(siga, am, ctable)
        }
        ols.random.list <- list(siga = siga, sesiga = sesiga, 
            vard = vard, degfd = degfd)
        ols.genpar.list <- comtopar(am$v, am$l, siga, vara, vsiga, 
            sesiga, ctable)
        ols.list <- c(aov.list, ols.fixed.list, dme.exp.list, 
            dme.fit.list, ols.random.list, ols.genpar.list)
        outlist <- ols.list
    }
    else {
        if (posdef) {
            siga <- siga.posdef.specific(siga, am, ctable)
        }
        ols.random.list <- list(siga = siga, sesiga = sesiga, 
            vard = vard, degfd = degfd)
        ielist <- sigatoie(dyad.explist$cnames, dyad.explist$cnamesie, 
            siga, vsiga, sesiga, am, nsf)
        vclist <- sigatovc(ielist$siga, ielist$vsiga, ielist$sesiga, 
            am, nsf)
        ols.specific.genpar.list <- vector("list", length = length(vclist$phencovclasses))
        for (ic in 1:length(vclist$phencovclasses)) {
            ols.specific.genpar.list[[ic]] <- comtopar.specific(nrow(vclist$vc[[ic]]), 
                am$l, vclist$vc[[ic]], vara, vclist$var.vc[[ic]], 
                vclist$se.vc[[ic]], ctable, ic, vclist$phencovclasses[ic], 
                vclist$rownames.vc.long[[ic]], siga)
        }
        names(ols.specific.genpar.list) <- vclist$phencovclasses
        ols.list <- c(aov.list, ols.fixed.list, dme.exp.list, 
            dme.fit.list, ols.random.list, list(specific = ols.specific.genpar.list))
        outlist <- ols.list
    }
    cat("DME substep with OLS-fixed-effects completed:\n")
    if (fixedgls && posdef) {
        cat("\nGLS-fixed-effects step:\n")
        if (am$l > 1) {
            cat("Warning: Multivariate GLS is not same as multiple univariate GLS's\n")
        }
        gls.list <- gls.iter.b(am, b, siga, dyad.explist, fixedglsopt, 
            dmefglsopt, dmeopt, ctable, ncomp.pcr, dmekeepfit, 
            mmat)
        if (gls.list$ok) {
            cat("GLS-fixed-effects step completed successfully:\n")
            cat("DME substep:\n")
            cat("Components to genetic parameters and SE's:\n")
            nsf <- length(specific.components)
            if (nsf == 0) {
                cat("GLS-fixed-effects - genetic parameters with nonspecific components:\n")
                gls.genpar.list <- comtopar(am$v, am$l, gls.list$siga, 
                  gls.list$msa, gls.list$vsiga, gls.list$sesiga, 
                  ctable)
                gls.list.out <- list(b = gls.list$b, seb = gls.list$seb, 
                  siga = gls.list$siga, sesiga = gls.list$sesiga, 
                  vard = gls.list$vard, msr = gls.list$msr, msrdf = gls.list$msrdf, 
                  msa = gls.list$msa)
                gls.list.out <- c(gls.list.out, gls.genpar.list, 
                  gls.list$dme.fit.list)
                outlist <- c(ols.list, list(gls = gls.list.out))
            }
            else {
                cat("GLS-fixed-effects - genetic parameters with specific components:\n")
                ielist <- sigatoie(dyad.explist$cnames, dyad.explist$cnamesie, 
                  gls.list$siga, gls.list$vsiga, gls.list$sesiga, 
                  am, nsf)
                vclist <- sigatovc(ielist$siga, ielist$vsiga, 
                  ielist$sesiga, am, nsf)
                gls.specific.genpar.list <- vector("list", length = length(vclist$phencovclasses))
                for (ic in 1:length(vclist$phencovclasses)) {
                  gls.specific.genpar.list[[ic]] <- comtopar.specific(nrow(vclist$vc[[ic]]), 
                    am$l, vclist$vc[[ic]], vara, vclist$var.vc[[ic]], 
                    vclist$se.vc[[ic]], ctable, ic, vclist$phencovclasses[ic], 
                    vclist$rownames.vc.long[[ic]], siga)
                }
                names(gls.specific.genpar.list) <- vclist$phencovclasses
                gls.list.out <- list(b = gls.list$b, seb = gls.list$seb, 
                  siga = gls.list$siga, sesiga = gls.list$sesiga, 
                  vard = gls.list$vard, msr = gls.list$msr, msrdf = gls.list$msrdf, 
                  msa = gls.list$msa)
                gls.list.out <- c(gls.list.out, list(specific = gls.specific.genpar.list), 
                  gls.list$dme.fit.list)
                outlist <- c(ols.list, list(gls = gls.list.out))
            }
            cat("DME substep completed:\n")
        }
        else if (!gls.list$ok) {
            outlist <- ols.list
            cat("GLS-fixed-effects step abandoned:\n")
        }
    }
    return(outlist)
}
