% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{get_result.default}
\alias{get_result.default}
\title{Get final result}
\usage{
\method{get_result}{default}(obj, group_id = T)
}
\arguments{
\item{obj}{An object. Can be all classes: short, lab, date.}

\item{group_id}{A logical scalar, default is TRUE.True is grouped by id, otherwise, it isn't grouped.}
}
\value{
A data frame. The final result.
}
\description{
Get final result
}
\examples{
id <- c("01", "02", "03")
site <- c("site 01", "site 02", "site 03")
sex <- c("f", "m", "f")
preg_yn_e2 <- c("y", "y", "y")
preg_res_e2 <- c("neg", "neg", "neg")
preg_yn_e3 <- c("y", "y", "n")
preg_res_e3 <- c("neg", "pos", "unnes")

df <- data.frame(
  id, site, sex,
  preg_yn_e2, preg_res_e2,
  preg_yn_e3, preg_res_e3,
  stringsAsFactors = FALSE
)

preg <- system.file("preg.xlsx", package = "dmtools")
obj_short <- short(preg, id, "LBORRES", c("site", "sex"))

obj_short <- check(obj_short, df)
get_result(obj_short)
}
