% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_boxplot.R
\name{plot_boxplot}
\alias{plot_boxplot}
\title{\code{ggplot} type boxplots for each vars.cont by partition level.}
\usage{
plot_boxplot(
  data,
  partition.name,
  vars.cont,
  vars.cont.names = NULL,
  unclass.name = "Unclassified",
  include.unclass = FALSE,
  add.n = FALSE,
  nc.facet = 10
)
}
\arguments{
\item{data}{The dataset.}

\item{partition.name}{string. Name of the partition (in data). The partition
variable should be a factor.}

\item{vars.cont}{vector of strings. variables to plot (continuous only).}

\item{vars.cont.names}{Optional. Names for displaying the continuous
variables. (given in the same order than \code{vars.cont})}

\item{unclass.name}{If applicable, name for the unclassified observations in
the partition.}

\item{include.unclass}{boolean, should boxplot be displayed for the
unclassified or should they be excluded from the plot.}

\item{add.n}{Boolean. Should the number of samples per cluster be indicated
on the x axis and color legend.}

\item{nc.facet}{integer. Number of columns in the \code{facet_wrap()}}
}
\value{
\code{ggplot} object.
}
\description{
\code{ggplot} type boxplots for each vars.cont by partition level.
}
\examples{
data(cancer, package = "survival")
cancer$status <- factor(cancer$status)
plot_boxplot(data = cancer, partition.name = "status",
                  vars.cont = c("age", "meal.cal", "wt.loss"))

## With unclassifieds
cancer$status.2 <- as.character(cancer$status)
cancer$status.2[sample(1:nrow(cancer), 30)] <- "Unclassif."
cancer$status.2 <- factor(cancer$status.2)
plot_boxplot(data = cancer, partition.name = "status.2",
                  vars.cont = c("age", "meal.cal", "wt.loss"),
                  unclass.name = "Unclassif.", include.unclass = TRUE)

## With unclassifieds (as NA)
cancer$status.3 <- cancer$status
cancer$status.3[sample(1:nrow(cancer), 30)] <- NA
plot_boxplot(data = cancer, partition.name = "status.3",
                  vars.cont = c("age", "meal.cal", "wt.loss"),
                  unclass.name = NA, include.unclass = TRUE, add.n = TRUE)
}
