% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doRedis.R
\name{setReduce}
\alias{setReduce}
\title{Set two-level distributed reduction}
\usage{
setReduce(fun = NULL)
}
\arguments{
\item{fun}{a function of two arguments, set to NULL to disable combining, or
leave missing to implicitly set the gather function formally identical to the
\code{.combine} function but with an empty environment.}
}
\value{
\code{fun} is invisibly returned, or TRUE is returned when
 \code{fun} is missing (in which case the \code{.combine} function is used).
}
\description{
Instruct doRedis to perform either the \code{.combine} reduction function
or another specified function per task on each
worker before returning results, cf. \code{\link{foreach}}.
Combined results are then processed through
the specified function \code{fun} for two levels of reduction
functions. This option only applies when the \code{chunkSize} option is greater than
one, and automatically sets \code{.multicombine=FALSE}.
}
\details{
This approach can improve performance when the \code{.combine} function is
expensive to compute, and when function emits significantly less data than
it consumes. The same effect is usually achievable by simply adding the reduction
function to the end of the foreach loop expression (but must be decided prior
to run time).
}
\note{
Do not use this function, use the 'compile-time' version instead directly
in the foreach loop: \code{foreach(..., .options.redis=list(reduce=...))}.
Setting a reduction function at run-time will generally alter the result.
}
\examples{
\dontrun{
setChunkSize(3)
foreach(j=1:10, .combine=c, .options.redis=list(reduce=list)) \%dopar\% j
}

}
\seealso{
\code{\link{foreach}}, \code{\link{setChunkSize}}
}
