% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R
\name{dots}
\alias{dots}
\title{Make dot density plots}
\usage{
dots(
  shp,
  cols,
  engine = engine_terra,
  divisor = 250,
  min_point = 0.1 * divisor
)
}
\arguments{
\item{shp}{input shp with \code{sf} geometry.}

\item{cols}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> columns to produce dots for.}

\item{engine}{backend to use. Default is \code{engine_terra}.}

\item{divisor}{Number of people per dot. Default is 250.}

\item{min_point}{Minimum number of people to generate one dot. Defaults to 10\% of the divisor.}
}
\value{
A ggplot
}
\description{
Make dot density plots
}
\examples{
data('suffolk')
# subset to first 20 rows for speed on CRAN
dots(suffolk[1:20, ], c(vap_black), divisor = 2000)
}
