% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{getTrees}
\alias{getTrees}
\title{Estimate lineage tree topologies, branch lengths,
and internal node states if desired}
\usage{
getTrees(
  clones,
  trait = NULL,
  id = NULL,
  dir = NULL,
  modelfile = NULL,
  build = "pratchet",
  exec = NULL,
  igphyml = NULL,
  fixtrees = FALSE,
  nproc = 1,
  quiet = 0,
  rm_temp = TRUE,
  palette = NULL,
  seq = NULL,
  collapse = FALSE,
  ...
)
}
\arguments{
\item{clones}{a tibble of \code{airrClone} objects, the output of 
\link{formatClones}}

\item{trait}{trait to use for parsimony models (required if 
\code{igphyml} specified)}

\item{id}{unique identifer for this analysis (required if 
\code{igphyml} or \code{dnapars} specified)}

\item{dir}{directory where temporary files will be placed.}

\item{modelfile}{file specifying parsimony model to use}

\item{build}{program to use for tree building (pratchet, pml, 
dnapars, dnaml, igphyml)}

\item{exec}{location of desired phylogenetic executable}

\item{igphyml}{optional location of igphyml executible for parsimony}

\item{fixtrees}{if TRUE, use supplied tree topologies}

\item{nproc}{number of cores to parallelize computations}

\item{quiet}{amount of rubbish to print to console}

\item{rm_temp}{remove temporary files (default=TRUE)}

\item{palette}{a named vector specifying colors for each state}

\item{seq}{column name containing sequence information}

\item{collapse}{Collapse internal nodes with identical sequences?}

\item{...}{Additional arguments passed to tree building programs}
}
\value{
A list of \code{phylo} objects in the same order as \code{data}.
}
\description{
\code{getTrees} Tree building function.
}
\details{
Estimates phylogenetic tree topologies and branch lengths for a list of 
\code{airrClone} objects. By default, it will use phangnorn::pratchet to 
estimate maximum parsimony tree topologies, and ape::acctran to estimate 
branch lengths. If \code{igpyhml} is specified, internal node \code{trait} 
values will be predicted by maximum parsimony. In this case, \code{dir} will 
need to be specified as a temporary directory to place all the intermediate 
files (will be created if not available). Further, \code{id} will need to 
specified to serve as a unique identifier for the temporary files. This 
should be chosen to ensure that multiple \code{getTrees} calls using the same
\code{dir} do not overwrite each others files. 

\code{modelfile} is written automatically if not specified, but doesn't 
include any constraints. Intermediate files are deleted by default. This can
be toggled using (\code{rm_files}).

For examples and vignettes, see https://dowser.readthedocs.io
}
\examples{
data(ExampleClones)

trees <- getTrees(ExampleClones[10,])
plotTrees(trees)[[1]]

\dontrun{
data(ExampleClones)

trees <- getTrees(ExampleClones[10,],igphyml="/path/to/igphyml",
         id="temp",dir="temp", trait="sample_id")
plotTrees(trees)[[1]]
}
}
\seealso{
\link{formatClones}, \link{bootstrapTrees}, \link{buildPhylo},
\link{buildPratchet}, \link{buildPML}, \link{buildIgphyml}
}
