% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dpcr.R
\name{read_QX200}
\alias{read_QX200}
\title{Read QX200}
\source{
Droplet Digital PCR Applications Guide, Rev. A, Bulletin 6407, Biorad, 
accessed on 28.10.2016, 
\url{http://www.bio-rad.com/webroot/web/pdf/lsr/literature/Bulletin_6407.pdf}.
}
\usage{
read_QX200(input, ext = NULL)
}
\arguments{
\item{input}{name of the input file (\code{character}) or input object 
(\code{data.frame}).}

\item{ext}{extension of the file ().}
}
\value{
An object of \code{\linkS4class{adpcr}} class.
}
\description{
Reads digital PCR data from the QX200 Droplet Digital PCR System (Bio-Rad).
}
\note{
The volume and its uncertainty are taken from the literature (see 
references).
}
\author{
Michal Burdukiewcz, Stefan Roediger
}
\references{
Corbisier, P. et al (2015). DNA copy number concentration measured by digital 
and droplet digital quantitative PCR using certified reference materials. 
Analytical and Bioanalytical Chemistry 407, 1831-1840.
}
\seealso{
See \code{\link{read_dpcr}} for detailed description of input files.
}
\keyword{utilities}

