% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Figure_correlation_barplot.R
\name{Figure.correlation.barplot}
\alias{Figure.correlation.barplot}
\title{Produces a Figure of the correlation coefficients.}
\usage{
Figure.correlation.barplot(corr.1, corr.2, corr.3, corr.1.full, corr.2.full,
  corr.3.full, col.names.season)
}
\arguments{
\item{corr.1}{the output from using function 'correlation.function' for the 1st climate variable comparing near and far-pith. Depending on the order of the inputs into the function 'correlation.function' will determine the color of the resultant box-plot (1st item is black, and 2nd item is gray)}

\item{corr.2}{same as corr.1 but for the second climate variable}

\item{corr.3}{same as corr.1 but for the third climate variable}

\item{corr.1.full}{the output from using function 'correlation.function' for the full dataset. correlations for the full dataset are shown as a grey dashed line.}

\item{corr.2.full}{same as corr.1.full but for the second climate variable}

\item{corr.3.full}{same as corr.1.full but for the third climate variable}

\item{col.names.season}{col.names.season<- list("SON_2", "DJF_2", "MAM_2", "JJA_2", "SON_1", "DJF_1", "MAM_1", "JJA_1", "SON", "DJF", "MAM", "JJA")}
}
\value{
This returns a figure.
}
\description{
Produce a figure with 3 panels, each panel is for a different climate variable. An example of this figure in included in "On the influence of tree size on the climate - growth relationship of New Zealand kauri (Agathis australis): insights from annual, monthly and daily growth patterns. J Wunder, AM Fowler, ER Cook, M Pirie, SPJ McCloskey. Trees 27 (4), 937-948"
}
\examples{
\dontrun{ Figure.correlation.barplot(corr.temp, corr.prec, corr.SOI,
   corr.temp.full, corr.prec.full, corr.SOI.full, col.names.season) }
}

