% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Table.R
\docType{methods}
\name{todbc-tables}
\alias{todbc-tables}
\alias{sqlData,Teradata-method}
\title{Convenience functions for reading/writing DBMS tables}
\usage{
\S4method{sqlData}{Teradata}(con, value, row.names = NA, ...)
}
\arguments{
\item{con}{A database connection.}

\item{value}{A data.frame to write to the database.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{...}{Other arguments used by individual methods.}
}
\description{
Convenience functions for reading/writing DBMS tables
}
\examples{
\dontrun{
library(dplyr.teradata)
con <- dbConnect(todbc())
dbListTables(con)
dbWriteTable(con, "mtcars", mtcars, temporary = TRUE)
dbReadTable(con, "mtcars")

dbListTables(con)
dbExistsTable(con, "mtcars")

# A zero row data frame just creates a table definition.
dbWriteTable(con, "mtcars2", mtcars[0, ], temporary = TRUE)
dbReadTable(con, "mtcars2")

dbDisconnect(con)
}
}
