% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.R
\name{ranking}
\alias{ranking}
\alias{row_number}
\alias{ntile}
\alias{min_rank}
\alias{dense_rank}
\alias{percent_rank}
\alias{cume_dist}
\title{Windowed rank functions.}
\usage{
row_number(x)

ntile(x, n)

min_rank(x)

dense_rank(x)

percent_rank(x)

cume_dist(x)
}
\arguments{
\item{x}{a vector of values to rank. Missing values are left as is.
If you want to treat them as the smallest or largest values, replace
with Inf or -Inf before ranking.}

\item{n}{number of groups to split up into.}
}
\description{
Six variations on ranking functions, mimicing the ranking functions
described in SQL2003. They are currently implemented using the built in
\code{rank} function, and are provided mainly as a convenience when
converting between R and SQL. All ranking functions map smallest inputs
to smallest outputs. Use \code{\link[=desc]{desc()}} to reverse the direction.
}
\details{
\itemize{
\item \code{row_number()}: equivalent to \code{rank(ties.method = "first")}
\item \code{min_rank()}: equivalent to \code{rank(ties.method = "min")}
\item \code{dense_rank()}: like \code{min_rank()}, but with no gaps between
ranks
\item \code{percent_rank()}: a number between 0 and 1 computed by
rescaling \code{min_rank} to \code{[0, 1]}
\item \code{cume_dist()}: a cumulative distribution function. Proportion
of all values less than or equal to the current rank.
\item \code{ntile()}: a rough rank, which breaks the input vector into
\code{n} buckets.
}
}
\examples{
x <- c(5, 1, 3, 2, 2, NA)
row_number(x)
min_rank(x)
dense_rank(x)
percent_rank(x)
cume_dist(x)

ntile(x, 2)
ntile(runif(100), 10)

# row_number can be used with single table verbs without specifying x
# (for data frames and databases that support windowing)
mutate(mtcars, row_number() == 1L)
mtcars \%>\% filter(between(row_number(), 1, 10))
}
