% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise.R
\name{scoped}
\alias{scoped}
\title{Operate on a selection of variables}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.funs}{A function \code{fun}, a quosure style lambda \code{~ fun(.)} or a list of either form.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}

\item{...}{Additional arguments for the function calls in
\code{.funs}. These are evaluated only once, with \link[rlang:dyn-dots]{tidy dots} support.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Scoped verbs (\verb{_if}, \verb{_at}, \verb{_all}) have been superseded by the use of
\code{\link[=pick]{pick()}} or \code{\link[=across]{across()}} in an existing verb. See \code{vignette("colwise")} for
details.

The variants suffixed with \verb{_if}, \verb{_at} or \verb{_all} apply an
expression (sometimes several) to all variables within a specified
subset. This subset can contain all variables (\verb{_all} variants), a
\code{\link[=vars]{vars()}} selection (\verb{_at} variants), or variables selected with a
predicate (\verb{_if} variants).

The verbs with scoped variants are:
\itemize{
\item \code{\link[=mutate]{mutate()}}, \code{\link[=transmute]{transmute()}} and \code{\link[=summarise]{summarise()}}. See \code{\link[=summarise_all]{summarise_all()}}.
\item \code{\link[=filter]{filter()}}. See \code{\link[=filter_all]{filter_all()}}.
\item \code{\link[=group_by]{group_by()}}. See \code{\link[=group_by_all]{group_by_all()}}.
\item \code{\link[=rename]{rename()}} and \code{\link[=select]{select()}}. See \code{\link[=select_all]{select_all()}}.
\item \code{\link[=arrange]{arrange()}}. See \code{\link[=arrange_all]{arrange_all()}}
}

There are three kinds of scoped variants. They differ in the scope
of the variable selection on which operations are applied:
\itemize{
\item Verbs suffixed with \verb{_all()} apply an operation on all variables.
\item Verbs suffixed with \verb{_at()} apply an operation on a subset of
variables specified with the quoting function \code{\link[=vars]{vars()}}. This
quoting function accepts \code{\link[tidyselect:vars_select]{tidyselect::vars_select()}} helpers like
\code{\link[=starts_with]{starts_with()}}. Instead of a \code{\link[=vars]{vars()}} selection, you can also
supply an \link[rlang:is_integerish]{integerish} vector of column
positions or a character vector of column names.
\item Verbs suffixed with \verb{_if()} apply an operation on the subset of
variables for which a predicate function returns \code{TRUE}. Instead
of a predicate function, you can also supply a logical vector.
}
}
\section{Grouping variables}{


Most of these operations also apply on the grouping variables when
they are part of the selection. This includes:
\itemize{
\item \code{\link[=arrange_all]{arrange_all()}}, \code{\link[=arrange_at]{arrange_at()}}, and \code{\link[=arrange_if]{arrange_if()}}
\item \code{\link[=distinct_all]{distinct_all()}}, \code{\link[=distinct_at]{distinct_at()}}, and \code{\link[=distinct_if]{distinct_if()}}
\item \code{\link[=filter_all]{filter_all()}}, \code{\link[=filter_at]{filter_at()}}, and \code{\link[=filter_if]{filter_if()}}
\item \code{\link[=group_by_all]{group_by_all()}}, \code{\link[=group_by_at]{group_by_at()}}, and \code{\link[=group_by_if]{group_by_if()}}
\item \code{\link[=select_all]{select_all()}}, \code{\link[=select_at]{select_at()}}, and \code{\link[=select_if]{select_if()}}
}

This is not the case for summarising and mutating variants where
operations are \emph{not} applied on grouping variables. The behaviour
depends on whether the selection is \strong{implicit} (\code{all} and \code{if}
selections) or \strong{explicit} (\code{at} selections). Grouping variables
covered by explicit selections (with \code{\link[=summarise_at]{summarise_at()}},
\code{\link[=mutate_at]{mutate_at()}}, and \code{\link[=transmute_at]{transmute_at()}}) are always an error. For
implicit selections, the grouping variables are always ignored. In
this case, the level of verbosity depends on the kind of operation:
\itemize{
\item Summarising operations (\code{\link[=summarise_all]{summarise_all()}} and \code{\link[=summarise_if]{summarise_if()}})
ignore grouping variables silently because it is obvious that
operations are not applied on grouping variables.
\item On the other hand it isn't as obvious in the case of mutating
operations (\code{\link[=mutate_all]{mutate_all()}}, \code{\link[=mutate_if]{mutate_if()}}, \code{\link[=transmute_all]{transmute_all()}}, and
\code{\link[=transmute_if]{transmute_if()}}). For this reason, they issue a message
indicating which grouping variables are ignored.
}
}

