% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpm.R
\name{get_syntax}
\alias{get_syntax}
\title{Retrieve lavaan model syntax from fitted dpm model}
\usage{
get_syntax(model, print = TRUE)
}
\arguments{
\item{model}{A \code{dpm} object.}

\item{print}{Print the syntax to the console so it is formatted properly?
Default is TRUE.}
}
\value{
Returns a string with the lavaan model syntax for \code{model}. If \code{print} is
TRUE, it is printed to the console as well.
}
\description{
This helper function provides a simple way to retrieve the
lavaan model syntax from a fitted \code{\link[=dpm]{dpm()}} object.
}
\examples{

data("WageData", package = "panelr")
wages <- panel_data(WageData, id = id, wave = t)
fit <- dpm(wks ~ pre(lag(union)) + lag(lwage), data = wages)
get_syntax(fit)

}
