% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpm.R
\name{lav_summary}
\alias{lav_summary}
\title{lavaan-style summary for dpm objects}
\usage{
lav_summary(x, ...)
}
\arguments{
\item{x}{The \code{\link{dpm}} object}

\item{...}{Other arguments to the lavaan function.}
}
\value{
Returns a \code{lavaan.summary} object which contains various
model data described in \verb{?lavaan::summary,lavaan-method}.
}
\description{
This is just a quick way to get \code{lavaan}'s summary instead
the more terse summary designed for \code{dpm} objects.
}
\examples{

# Load example data
data("WageData", package = "panelr")
# Convert data to panel_data format for ease of use
wages <- panel_data(WageData, id = id, wave = t)

fit <- dpm(wks ~ pre(lag(union)) + lag(lwage) | ed, data = wages)
lav_summary(fit)

}
