% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dracodecode.R
\name{draco_decode}
\alias{draco_decode}
\title{Decode Draco encoded raw bytes containing mesh or point cloud data}
\usage{
draco_decode(data, mesh3d = TRUE, ...)
}
\arguments{
\item{data}{\code{\link{raw}} bytes containing Draco data e.g. as read by
\code{\link{readBin}} OR a character vector containing a URL or a path to a
file on disk.}

\item{mesh3d}{Whether to return \code{rgl::mesh3d} object (when \code{TRUE},
the default) or something as close as possible to what is provided by the
Draco library (when \code{FALSE}).}

\item{...}{Additional arguments passed to \code{\link{download.file}} when
data is a URL (e.g. \code{quiet=TRUE} or \code{method})}
}
\value{
a \code{rgl::mesh3d} object or a list containing elements
  \code{points} and (for meshes). \code{faces}.
}
\description{
Decode Draco encoded raw bytes containing mesh or point cloud data
}
\details{
Note that the Draco library returns 0-based indices for the faces
  whereas R in general and \code{rgl::mesh3d} in particular expect 1-based
  indices. When \code{mesh3d=FALSE}, the result will have 0-based indices as
  returned by the Draco library.

  If \code{data} is an http/https URL it will be downloaded to a temporary
  location on disk (using \code{\link{download.file}}). If \code{data} is a
  character vector that does not look like a URL then it is assumed to refer
  to a file on disk (which will be read with \code{\link{readBin}}.
}
\examples{
\donttest{
# fetch test data
# originally downloaded from:
carurl='https://github.com/google/draco/blob/master/testdata/car.drc?raw=true'
\dontrun{
car.m=draco_decode(carurl)
}
# use cached version in package for example
car.m=draco_decode(system.file('draco/car.drc', package = 'dracor'))
str(car.m)

## show the result
if(requireNamespace("rgl", quietly=TRUE)) {
rgl::shade3d(car.m, col='red')

## demonstrate conversion of raw form to rgl::mesh3d object
car.raw=draco_decode(carurl, mesh3d=FALSE)
str(car.raw)
car.m2 = rgl::tmesh3d(
  vertices = car.raw$points,
  indices = car.raw$faces + 1,
  homogeneous = FALSE)
}
}
}
