% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{drake-package}
\alias{drake-package}
\alias{drake}
\title{A scalable solution for reproducibility and high-performance computing}
\description{
Drake is a workflow manager and build system.
}
\examples{
\dontrun{
library(drake)
load_basic_example()
make(my_plan) # Build everything.
make(my_plan) # Nothing is done because everything is already up to date.
reg2 = function(d){ # Change one of your functions.
  d$x3 = d$x^3
  lm(y ~ x3, data = d)
}
make(my_plan) # Only the pieces depending on reg2() get rebuilt.
readd(small) # Read/load from the cache.
loadd(large)
head(large)
clean() # Restart from scratch
make(my_plan, jobs = 2) # Distribute over 2 parallel jobs.
clean()
make(my_plan, jobs = 4, parallelism = "Makefile") # Distribute over 4 parallel R sessions.
make(my_plan, jobs = 4, parallelism = "Makefile") # Everything up to date.
clean(destroy = TRUE) # Totally remove the cache.
unlink(c("Makefile", "report.Rmd"))
}
}
\references{
\url{https://github.com/wlandau-lilly/drake}
}
\author{
William Michael Landau \email{will.landau@lilly.com}
}
