% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_plans.R
\name{gather_by}
\alias{gather_by}
\title{Gather multiple groupings of targets}
\usage{
gather_by(plan, ..., prefix = "target", gather = "list")
}
\arguments{
\item{plan}{workflow plan data frame of prespecified targets}

\item{...}{Symbols, columns of \code{plan} to define target groupings
passed to \code{dplyr::group_by()}.
A \code{\link[=gather_plan]{gather_plan()}} call is applied for each grouping.
Groupings with all \code{NA}s in the selector variables are ignored.}

\item{prefix}{character, prefix for naming the new targets.
Suffixes are generated from the values of the columns
specified in \code{...}.}

\item{gather}{function used to gather the targets. Should be
one of \code{list(...)}, \code{c(...)}, \code{rbind(...)}, or similar.}
}
\description{
Perform several calls to \code{\link[=gather_plan]{gather_plan()}}
based on groupings from columns in the plan,
and then row-bind the new targets to the plan.
}
\examples{
plan <- drake_plan(
  data = get_data(),
  informal_look = inspect_data(data, mu = mu__),
  bayes_model = bayesian_model_fit(data, prior_mu = mu__)
)
plan <- evaluate_plan(plan, rules = list(mu__ = 1:2), trace = TRUE)
gather_by(plan, mu___from, gather = "dplyr::bind_rows")
gather_by(plan, mu__, mu___from, prefix = "x")
reduce_by(plan, mu___from, begin = "list(", end = ")", op = ", ")
reduce_by(plan, mu__, mu___from)
}
\seealso{
gather_plan, reduce_plan, reduce_by
}
