% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_helpers.R
\name{cancel_if}
\alias{cancel_if}
\title{Cancel a target mid-build under some condition
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}})`}
\usage{
cancel_if(condition, allow_missing = TRUE)
}
\arguments{
\item{condition}{Logical, whether to cancel the target.}

\item{allow_missing}{Logical. If \code{FALSE}, \code{drake} will not cancel
the target if it is missing from the cache (or if you removed the
key with \code{clean()}).}
}
\value{
Nothing.
}
\description{
Cancel a target mid-build if some logical condition is met.
Upon cancellation, \code{drake} halts the current target and moves to the
next one. The target's previous value and metadata, if they exist,
remain in the cache.
}
\examples{
\dontrun{
isolate_example("cancel_if()", {
f <- function(x) {
  cancel_if(x > 1)
  Sys.sleep(2) # Does not run if x > 1.
}
g <- function(x) f(x)
plan <- drake_plan(y = g(2))
make(plan)
# Does not exist.
# readd(y)
})
}
}
\seealso{
cancel
}
