% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_drake.R
\name{use_drake}
\alias{use_drake}
\title{Use drake in a project
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}}
\usage{
use_drake(open = interactive())
}
\arguments{
\item{open}{Logical, whether to open \code{make.R} for editing.}
}
\description{
Add top-level R script files to use \code{drake}
in your data analysis project. For details, read
\url{https://books.ropensci.org/drake/projects.html}
}
\details{
Files written:
\enumerate{
\item \code{make.R}: a suggested main R script for batch mode.
\item \verb{_drake.R}: a configuration R script for
the \href{https://docs.ropensci.org/drake/reference/r_make.html}{\verb{r_*()}} functions documented at # nolint
\url{https://books.ropensci.org/drake/projects.html#safer-interactivity}. # nolint
Remarks:
}
\itemize{
\item There is nothing magical about the name, \code{make.R}.
You can call it whatever you want.
\item Other supporting scripts, such as \code{R/packages.R},
\code{R/functions.R}, and \code{R/plan.R}, are not included.
\item You can find examples at
\url{https://github.com/wlandau/drake-examples}
and download examples with \code{\link[=drake_example]{drake_example()}}
(e.g. \code{drake_example("main")}).
}
}
\examples{
\dontrun{
# use_drake(open = FALSE) # nolint
}
}
