% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{find_cache}
\alias{find_cache}
\title{Search up the file system for the nearest drake cache.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}}
\usage{
find_cache(path = getwd(), dir = NULL, directory = NULL)
}
\arguments{
\item{path}{Starting path for search back for the cache.
Should be a subdirectory of the drake project.}

\item{dir}{Character, name of the folder containing the cache.}

\item{directory}{Deprecated. Use \code{dir}.}
}
\value{
File path of the nearest drake cache or \code{NULL}
if no cache is found.
}
\description{
Only works if the cache is a file system in a
hidden folder named \verb{.drake/} (default).
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the target.
# Find the file path of the project's cache.
# Search up through parent directories if necessary.
find_cache()
}
})
}
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}},
}
