% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-plan.R
\name{drake_plan}
\alias{drake_plan}
\title{Create a workflow plan data frame
for the \code{plan} argument of \code{\link[=make]{make()}}.}
\usage{
drake_plan(..., list = character(0), file_targets = NULL,
  strings_in_dots = NULL, tidy_evaluation = NULL, transform = TRUE,
  trace = FALSE, envir = parent.frame(), tidy_eval = TRUE)
}
\arguments{
\item{...}{A collection of symbols/targets
with commands assigned to them. See the examples for details.}

\item{list}{Deprecated}

\item{file_targets}{Deprecated.}

\item{strings_in_dots}{Deprecated.}

\item{tidy_evaluation}{Deprecated. Use \code{tidy_eval} instead.}

\item{transform}{Logical, whether to transform the plan
into a larger plan with more targets.
This is still an experimental feature,
so please check your workflow with \code{vis_drake_graph()}
before running it with \code{make()}.
Requires the \code{transform} and \code{group} fields identified
by \code{target()}. See the examples for details.}

\item{trace}{Logical, whether to add columns to show
what happens during target transformations.}

\item{envir}{Environment for tidy evaluation.}

\item{tidy_eval}{Logical, whether to use tidy evaluation
(e.g. unquoting/\code{!!}) when resolving commands.
Tidy evaluation in transformations is always turned on
regardless of the value you supply to this argument.}
}
\value{
A data frame of targets, commands, and optional
custom columns.
}
\description{
A \code{drake} plan is a data frame with columns
\code{"target"} and \code{"command"}. Each target is an R object
produced in your workflow, and each command is the
R code to produce it. The \code{"target"} column has the names
of the targets, and no duplicate elements are allowed.
The \code{"command"} column is either a character vector of
code strings or a list of language objects.
}
\details{
\code{drake} has special syntax for generating large plans.
Your code will look something like
\code{drake_plan(x = target(cmd, transform = f(y, z), group = g)}
where \code{f()} is either \code{map()}, \code{cross()}, or \code{combine()}
(similar to \code{purrr::pmap()}, \code{tidy::crossing()}, and \code{dplyr::summarize()},
respectively). These verbs mimic Tidyverse behavior to scale up
existing plans to large numbers of targets.
You can read about this interface at
\url{https://ropenscilabs.github.io/drake-manual/plans.html#create-large-plans-the-easy-way}. # nolint

There is also special syntax for declaring input files,
output files, and knitr reports so dependencies are
properly accounted for (\code{\link[=file_in]{file_in()}}, \code{\link[=file_out]{file_out()}}, and
\code{\link[=knitr_in]{knitr_in()}}, respectively.

Besides \code{"target"} and \code{"command"}, you may include
optional columns in your workflow plan. For details, visit
\url{https://ropenscilabs.github.io/drake-manual/plans.html#special-custom-columns-in-your-plan}
}
\examples{
isolate_example("Contain side effects", {
# Create workflow plan data frames.
mtcars_plan <- drake_plan(
  write.csv(mtcars[, c("mpg", "cyl")], file_out("mtcars.csv")),
  value = read.csv(file_in("mtcars.csv"))
)
mtcars_plan
make(mtcars_plan) # Makes `mtcars.csv` and then `value`
head(readd(value))
# You can use knitr inputs too. See the top command below.
load_mtcars_example()
head(my_plan)
# The `knitr_in("report.Rmd")` tells `drake` to dive into the active
# code chunks to find dependencies.
# There, `drake` sees that `small`, `large`, and `coef_regression2_small`
# are loaded in with calls to `loadd()` and `readd()`.
deps_code("report.Rmd")

# Use transformations to generate large plans.
# This feature is experimental, so please
# check your workflow with `vis_drake_graph()`
# before running `make()`.
# Read more at
# <https://ropenscilabs.github.io/drake-manual/plans.html#create-large-plans-the-easy-way>. # nolint
drake_plan(
  data = target(
    simulate(nrows),
    transform = map(nrows = c(48, 64)),
    custom_column = 123
  ),
  reg = target(
    reg_fun(data),
   transform = cross(reg_fun = c(reg1, reg2), data)
  ),
  summ = target(
    sum_fun(data, reg),
   transform = cross(sum_fun = c(coef, residuals), reg)
  ),
  winners = target(
    min(summ),
    transform = combine(summ, .by = c(data, sum_fun))
  )
)

# Set trace = TRUE to show what happened during the transformation process.
drake_plan(
  data = target(
    simulate(nrows),
    transform = map(nrows = c(48, 64)),
    custom_column = 123
  ),
  reg = target(
    reg_fun(data),
   transform = cross(reg_fun = c(reg1, reg2), data)
  ),
  summ = target(
    sum_fun(data, reg),
   transform = cross(sum_fun = c(coef, residuals), reg)
  ),
  winners = target(
    min(summ),
    transform = combine(summ, .by = c(data, sum_fun))
  ),
  trace = TRUE
)

# You can create your own custom columns too.
# See ?triggers for more on triggers.
drake_plan(
  website_data = target(
    command = download_data("www.your_url.com"),
    trigger = "always",
    custom_column = 5
  ),
  analysis = analyze(website_data)
)

# Tidy evaluation can help generate super large plans.
sms <- rlang::syms(letters) # To sub in character args, skip this.
drake_plan(x = target(f(char), transform = map(char = !!sms)))
})
}
