% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-slice.R
\name{drake_slice}
\alias{drake_slice}
\title{Take a strategic subset of a dataset.}
\usage{
drake_slice(data, slices, index, margin = 1L, drop = FALSE)
}
\arguments{
\item{data}{A list, vector, data frame, matrix, or arbitrary array.
Anything with a \code{length()} or \code{dim()}.}

\item{slices}{Integer of length 1, number of slices (i.e. pieces)
of the whole dataset. Remember, \code{drake_slice(index = i)} returns
only slice number \code{i}.}

\item{index}{Integer of length 1, which piece of the partition to return.}

\item{margin}{Integer of length 1, margin over which to split the data.
For example, for a data frame or matrix,
use \code{margin = 1} to split over rows and \code{margin = 2}
to split over columns. Similar to \code{MARGIN} in \code{apply()}.}

\item{drop}{Logical, for matrices and arrays.
If \code{TRUE},\code{ the result is coerced to the lowest possible dimension. See ?}[` for details.}
}
\value{
A subset of \code{data}.
}
\description{
\code{drake_slice()} is similar to \code{split()}.
Both functions partition data into disjoint subsets,
but whereas \code{split()} returns \emph{all} the subsets, \code{drake_slice()}
returns just \emph{one}. In other words, \code{drake_slice(..., index = i)}
returns \code{split(...)[[i]]}.
Other features:
1. \code{drake_slice()} works on vectors, data frames,
matrices, lists, and arbitrary arrays.
2. Like \code{parallel::splitIndices()}, \code{drake_slice()} tries to
distribute the data uniformly across subsets.
See the examples to learn why splitting is useful in \code{drake}.
}
\examples{
# Simple usage
x <- matrix(seq_len(20), nrow = 5)
x
drake_slice(x, slices = 3, index = 1)
drake_slice(x, slices = 3, index = 2)
drake_slice(x, slices = 3, index = 3)
drake_slice(x, slices = 3, margin = 2, index = 1)
# In drake, you can split a large dataset over multiple targets.
\dontrun{
plan <- drake_plan(
  large_data = iris,
  data_split = target(
    drake_slice(large_data, slices = 50, index = i),
    transform = map(i = !!seq_len(50))
  )
)
plan
cache <- storr::storr_environment()
make(plan, cache = cache, session_info = FALSE, verbose = FALSE)
readd(data_split_1L, cache = cache)
readd(data_split_2L, cache = cache)
}
}
