% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{spline_score}
\alias{spline_score}
\title{Univariate score estimation via the smoothing spline method of Cox 1985
and Ng 1994.}
\usage{
spline_score(x, df = 5, tol = 0.001, nmax = NULL)
}
\arguments{
\item{x}{vector of datapoints}

\item{df}{vector of smoothing parameters for the
non-parametric score estimator, corresponding to the
effective degrees of freedom for a smoothing spline.}

\item{tol}{numeric tolerance, minimum distance between neighbouring points,
to avoid singularities.}

\item{nmax}{if specified, overrides tol as maximal number of unique points.}
}
\value{
score function "rho" and derivative "drho", which take vector
input and yield a vector of score estimates corresponding to each df (in a
list if there are multiple df values). Also output the vector "df".
}
\description{
Univariate score estimation via the smoothing spline method of Cox 1985
and Ng 1994.
}
\examples{
# Single bandwidth
x <- stats::rlogis(100)
spl <- spline_score(x, df=6)
spl$rho(x)
spl$drho(x)

# Multiple bandwidths simultaneously
x <- stats::rt(n=100, df=4)
spl <- spline_score(x, df=c(2,5,10))
spl$rho(x)
}
