% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word.R
\name{lengthWord_probabilities}
\alias{lengthWord_probabilities}
\title{Probability of occurrence of the observed word of size m in a sequence at several positions}
\usage{
lengthWord_probabilities(m, sequence, pos, x, output_file = NULL, plot = FALSE)
}
\arguments{
\item{m}{An integer, the length word}

\item{sequence}{A vector of characters}

\item{pos}{A vector of integer positions}

\item{x}{An object of class \code{dmm}}

\item{output_file}{(Optional) A file containing the vector of probabilities (e.g,"C:/.../PROB.txt")}

\item{plot}{\code{FALSE} (default); \code{TRUE} (display figure plots of probabilities of occurrence of the observed word of size \code{m} by position)}
}
\value{
A dataframe of probability by position
}
\description{
Probability of occurrence of the observed word of size m in a sequence at several positions
}
\examples{
data(lambda, package = "drimmR")
length(lambda) <- 1000
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq", fit.method="sum")
m <- 2
lengthWord_probabilities(m, lambda, c(1,length(lambda)-m), dmm, plot=TRUE)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}, \link[drimmR]{word_probability}
}
\author{
Victor Mataigne, Alexandre Seiller
}
