% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_drug_demand.R
\name{f_drug_demand}
\alias{f_drug_demand}
\title{Drug Demand Prediction}
\usage{
f_drug_demand(
  df = NULL,
  newEvents = NULL,
  visitview = NULL,
  drug_description_df = NULL,
  treatment_by_drug = NULL,
  dosing_schedule_df = NULL,
  model_k0 = "zip",
  model_t0 = "exponential",
  model_ki = "zip",
  model_di = "lme",
  pilevel = 0.9,
  nyears = 4,
  nreps = 500,
  n.cores.max = 10,
  showplot = TRUE
)
}
\arguments{
\item{df}{A data frame for subject-level enrollment and event data,
including the following variables:
\code{trialsdt}, \code{usubjid}, \code{randdt},
\code{treatment}, \code{treatment_description},
\code{time}, \code{event}, \code{dropout}, and \code{cutoffdt}.}

\item{newEvents}{A data frame containing the imputed event data
for both ongoing and new patients, typically obtained from
the output of the \code{eventPred::getPrediction} function.
It contains the following variables:
\code{draw}, \code{usubjid}, \code{arrivalTime}, \code{treatment},
\code{treatment_description}, \code{time}, \code{event},
\code{dropout}, and \code{totalTime}.}

\item{visitview}{A data frame containing the observed drug dispensing
data, including the following variables:
\code{usubjid}, \code{visit}, \code{date}, \code{drug},
\code{drug_name}, \code{dose_unit}, \code{kit_number}, and
\code{dispensed_quantity}.}

\item{drug_description_df}{The drug description data frame
including \code{drug}, \code{drug_name}, and \code{dose_unit}.
It must be specified at the design stage. It will be replaced with
the observed information at the analysis stage.}

\item{treatment_by_drug}{The indicator matrix of treatment by drug
combinations.}

\item{dosing_schedule_df}{A data frame providing dosing schedule
information. It contains the following variables: \code{drug},
\code{target_days}, \code{target_kits}, and \code{max_cycles}.}

\item{model_k0}{The model for the number of skipped
visits between randomization and the first drug dispensing visit.}

\item{model_t0}{The model for the gap time between randomization
and the first drug dispensing visit when there is no visit skipping.}

\item{model_ki}{The model for the number of skipped
visits between two consecutive drug dispensing visits.}

\item{model_di}{The model for the dispensed doses at drug
dispensing visits.}

\item{pilevel}{The prediction interval level.}

\item{nyears}{The number of years after the data cut for prediction.}

\item{nreps}{The number of replications for simulation.}

\item{n.cores.max}{The maximum number of cores to use for parallel
computing. The actual number of cores used will be the minimum of
\code{n.cores.max} and half of the detected number of cores.}

\item{showplot}{A Boolean variable that controls whether or not to
show the drug dispensing model fit and drug demand prediction
plots. It defaults to \code{TRUE}.}
}
\value{
A list with the following components:

* \code{common_time_model} A Boolean variable that indicates whether
a common time model is used for drug dispensing visits.

* \code{fit_k0} The model fit for the number of skipped
visits between randomization and the first drug dispensing visit.

* \code{fit_t0} The model fit for the gap time between randomization
and the first drug dispensing visit when there is no visit skipping.

* \code{fit_t1} The model fit for the gap time between randomization
and the first drug dispensing visit when there is visit skipping.

* \code{fit_ki} The model fit for the number of skipped
visits between two consecutive drug dispensing visits.

* \code{fit_ti} The model fit for the gap time between two
consecutive drug dispensing visits.

* \code{fit_di} The model fit for the dispensed doses at drug
dispensing visits.

* \code{dosing_subject} A data frame for the observed and imputed
subject-level dosing records.

* \code{dosing_pred_df} A data frame for dosing summary by drug and
time point.

* \code{dosing_pred_pp} A data frame for dosing summary by drug and
time point per protocol.

* \code{dosing_pred_plot} A plot object for dosing prediction.
}
\description{
Obtains drug demand prediction via modeling and
simulation.
}
\examples{

\donttest{
set.seed(529)

tictoc::tic("event prediction")

pred <- eventPred::getPrediction(
  df = df2,
  to_predict = "event only",
  target_d = 250,
  event_model = "log-logistic",
  dropout_model = "none",
  pilevel = 0.95,
  nyears = 1,
  nreps = 200,
  showplot = FALSE,
  by_treatment = TRUE)

tictoc::toc()


tictoc::tic("drug demand prediction")

a <- f_drug_demand(
  df = df2,
  newEvents = pred$event_pred$newEvents,
  visitview = visitview2,
  treatment_by_drug = treatment_by_drug,
  dosing_schedule_df = dosing_schedule_df,
  model_k0 = "zip",
  model_t0 = "log-logistic",
  model_ki = "zip",
  model_di = "lme",
  pilevel = 0.95,
  nyears = 1,
  nreps = 200,
  n.cores.max = 2,
  showplot = FALSE)

tictoc::toc()

a$dosing_pred_plot
}

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
