% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dispensing_models.R
\name{f_fit_di}
\alias{f_fit_di}
\title{Model Fitting for Dispensed Doses}
\usage{
f_fit_di(df, model, nreps, showplot = TRUE)
}
\arguments{
\item{df}{The subject-level dosing data, including \code{usubjid},
\code{day}, \code{drug}, and \code{dose}.}

\item{model}{The model used to analyze the dispensed doses, with
options including "constant", "linear model", and
"linear mixed-effects model".}

\item{nreps}{The number of simulations for drawing posterior model
parameters.}

\item{showplot}{A Boolean variable that controls whether or not to
show the fitted dose bar chart. It defaults to \code{TRUE}.}
}
\value{
A list with three components:
\itemize{
\item \code{fit}: A list of results from the model fit that includes
\itemize{
\item \code{model}: The specific model used in the analysis.
\item \code{mud}: The estimated mean dose.
\item \code{vmud}: The estimated variance of \code{mud}.
\item \code{sigmab}: The estimated between-subject standard deviation.
\item \code{sigmae}: The estimated within-subject residual standard
deviation.
\item \code{aic}: The Akaike Information Criterion value.
\item \code{bic}: The Bayesian Information Criterion value.
}
\item \code{fit_plot}: A fitted dose bar chart.
\item \code{theta}: Posterior draws of model parameters.
\itemize{
\item \code{fixed}: Posterior draws of fixed model parameters:
\code{mud}, \code{sigmab}, and \code{sigmae}.
\item \code{random}: Posterior draws of subject random effects.
\item \code{usubjid}: The unique subject ID associated with
the subject random effects.
}
}
}
\description{
Fits a linear mixed-effects model to the dispensed doses
at drug dispensing visits.
}
\examples{
library(dplyr)

df <- df2 \%>\%
  mutate(arrivalTime = as.numeric(randdt - trialsdt + 1))

vf <- visitview2 \%>\%
  inner_join(df, by = "usubjid") \%>\%
  mutate(day = as.numeric(date - randdt + 1)) \%>\%
  select(drug, drug_name, dose_unit, usubjid, treatment,
         treatment_description, arrivalTime,
         time, event, dropout, day, dispensed_quantity) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid, treatment,
           treatment_description, arrivalTime,
           time, event, dropout, day) \%>\%
  summarise(dose = sum(dispensed_quantity), .groups = "drop_last") \%>\%
  mutate(cum_dose = cumsum(dose)) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid) \%>\%
  mutate(row_id = row_number())

vf1 <- vf \%>\% filter(drug == 3)
fit_di <- f_fit_di(vf1, model = "linear mixed-effects model", nreps = 200)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
