% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiple_tte.R
\name{os_tte}
\alias{os_tte}
\title{Probability that endpoint OS significant}
\usage{
os_tte(HRgo, n2, alpha, beta, hr1, hr2, id1, id2, fixed, rho, rsamp)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule;}

\item{n2}{total sample size for phase II; must be even number}

\item{alpha}{one- sided significance level}

\item{beta}{1-beta power for calculation of the number of events for phase III by Schoenfeld (1981) formula}

\item{hr1}{assumed true treatment effect on HR scale for endpoint OS}

\item{hr2}{assumed true treatment effect on HR scale for endpoint PFS}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{fixed}{choose if true treatment effects are fixed or random}

\item{rho}{correlation between the two endpoints}

\item{rsamp}{sample data set for Monte Carlo integration}
}
\value{
The output of the function \code{os_tte()} is the probability that endpoint OS significant.
}
\description{
This function calculate the probability that the endpoint OS is statistically significant.
In the context of cancer research OS stands for overall survival, a positive treatment effect in this endpoints is thus sufficient for a successful program.
}
\keyword{internal}
