% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fun.R
\name{sample_time}
\alias{sample_time}
\title{Draw a sample of n random times (from a given range).}
\usage{
sample_time(
  n = 1,
  from = "1970-01-01 00:00:00",
  to = Sys.time(),
  as_POSIXct = TRUE,
  tz = ""
)
}
\arguments{
\item{n}{Number dates to draw. 
Default: \code{n = 1}.}

\item{from}{Earliest date (as string). 
Default: \code{from = "1970-01-01 00:00:00"}.}

\item{to}{Latest date (as string). 
Default: \code{to = Sys.time()}.}

\item{as_POSIXct}{Boolean: Return calendar time ("POSIXct") object? 
Default: \code{as_POSIXct = TRUE}. 
If \code{as_POSIXct = FALSE}, a local time ("POSIXlt") object is returned 
(as a list).}

\item{tz}{Time zone.
Default: \code{tz = ""} (i.e., current system time zone,  
see \code{Sys.timezone()}). 
Use \code{tz = "UTC"} for Universal Time, Coordinated.}
}
\description{
\code{sample_time} draws a sample of  
\code{n} random times from a given range.
}
\details{
By default, \code{sample_time} draws \code{n = 1} 
random calendar time (as a "POSIXct" object) in the range 
\code{from = "1970-01-01 00:00:00"} 
\code{to = Sys.time()} (current time).

If \code{as_POSIXct = FALSE}, a local time ("POSIXlt") object is returned 
(as a list). 

The \code{tz} argument allows specifying time zones 
(see \code{Sys.timezone()} for current setting 
and \code{OlsonNames()} for options.)
}
\examples{
# Basics:
sample_time()
sample_time(n = 10)

# Specific ranges:
sort(sample_time(n = 10, from = (Sys.time() - 60)))  # within the last minute
sort(sample_time(n = 10, from = (Sys.time() - 1 * 60 * 60)))  # within the last hour
sort(sample_time(n = 10, from = Sys.time(), 
                           to = (Sys.time() + 1 * 60 * 60)))  # within the next hour
sort(sample_time(n = 10, from = "2020-12-31 00:00:00 CET", 
                           to = "2020-12-31 00:00:01 CET"))   # within 1 sec range
                           
# Local time (POSIXlt) objects (as list):
sample_time(as_POSIXct = FALSE)
unlist(sample_time(as_POSIXct = FALSE))

# Time zones:
sample_time(n = 3, tz = "UTC")
sample_time(n = 3, tz = "US/Pacific")
 
# Note: Oddity with sample(): 
sort(sample_time(n = 10, from = "2020-12-31 00:00:00 CET", 
                           to = "2020-12-31 00:00:00 CET"))  # range of 0!
# see sample(9:9, size = 10, replace = TRUE)

}
\seealso{
Other sampling functions: 
\code{\link{coin}()},
\code{\link{dice_2}()},
\code{\link{dice}()},
\code{\link{sample_char}()},
\code{\link{sample_date}()}
}
\concept{sampling functions}
